#ifndef AztecLib_ComponentFlagParam_Header
#define AztecLib_ComponentFlagParam_Header

#include <MMesh.h>
#include <MEditableMesh.h>
#include <params/MArrayParameter.h>
#include <params/MParameterFactory.h> 

#include <vector>

namespace Aztec {
  
  class ComponentFlagParam : public MIntParameter {
  public:
    ComponentFlagParam(const char *name, MComponentisedObject *object, MComponentisedObject::ComponentType type, int componentIndex);

    // MIntParameter methods
    int getValue();

    // MParameterObject methods
    int getDataType() const;
    int getDataMeaning() const;
    MStr getShortName() const;
    MStr getLongName() const;
    MStr getFriendlyName() const;
    MBaseObject* getOwner() const;
    void setOwner(MBaseObject *newOwner);
    bool isInputParameter();
    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);
    bool setValueString(const MStr &value);
    bool setValueInteger(int value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool setValueParameter(const MParameterObjectPtr &value);
    bool createKeyAt(long time);
    bool setFromParameter(MParameterObjectPtr src);
    bool isConnectable();
    bool isConnected();
    bool setInputParameter(const MParameterObjectPtr &input);
    MParameterObjectPtr getInputParameter();
    MParameterObjectPtr createCopy();

  private:
    const char *name;
    MComponentisedObject *object;

    MComponentisedObject::ComponentType type;
    unsigned int componentIndex;
  };


}



#endif