#ifndef MMeshModifier_Header
#define MMeshModifier_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MMeshModifier;
  typedef MRefCountedPtr<MMeshModifier> MMeshModifierPtr;

}

#include "MNamedObject.h"
#include "MMeshCreator.h"

#include "MMath.h"

namespace Aztec {

  /**
   * An MMeshModifier is an object which takes in a MeshShape, and also
   * outputs a mesh shape. It is used to perform modifications on a mesh, such
   * as bone deformation, scaling, squishing, rippling, or whatever.
   *
   * This class provides another input parameter, called inMesh, which is 
   * the input mesh forr this object.
   */
  class MGENEXPORT MMeshModifier : public MMeshCreator {
  public:
    MMeshModifier();
    ~MMeshModifier();

    /**
     * This gets the shape produced by this object. Note that this result
     * should not be stored anywhere, rather you should link to the "outMesh"
     * parameter instead.
     */
    MMeshShapePtr getInputShape();

    /**
     * This gets the parameter that stores our output shape. This should be 
     * used when linking this creator to other things.
     */
    MObjectParameterPtr getInputParameter();

    // MBaseObject methods. These are declared pure virtual once more
    // to ensure that implementing classes actually put these methods in.
    virtual MStr getClassName() = 0;
    virtual MBaseObjectPtr createNew() = 0;

  protected:
    /**
     * This is the input parameter object.
     */
    MObjectParameterPtr inputShapeParam;
  };
 
}

#endif
