#ifndef MVertexArrayParam_Header
#define MVertexArrayParam_Header

#include <params/MVector3KeyParameter.h>
#include <params/MArrayParameter.h>
#include <params/MParameterFactory.h> 
#include <MMesh.h>
#include <MEditableMesh.h>
#include <MAnimMesh.h>

namespace Aztec {
  
  class MeshVertexPosParam : public MVector3KeyParameter {
  public:
    MeshVertexPosParam(MMesh *mesh, int index, bool storable = true);
    // MVector3KeyParameter methods
    MVector3ValuePtr getVector3Value();
    void createXKeyAt(long time);
    void createYKeyAt(long time);
    void createZKeyAt(long time);
    MFloatKeyParameterPtr getXParameter();
    MFloatKeyParameterPtr getYParameter();
    MFloatKeyParameterPtr getZParameter();

    // MKeyParameter methods
    MKeyableValuePtr getKeyableValue();

    // MVector3Parameter methods
    MVector3 getValue();
    MVector3 getValue(long time);

    // MParameterObject methods
    int getDataType() const;
    int getDataMeaning() const;
    MStr getShortName() const;
    MStr getLongName() const;
    MStr getFriendlyName() const;
    MBaseObject* getOwner() const;
    void setOwner(MBaseObject *newOwner);
    bool isInputParameter();
    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);
    bool setValueString(const MStr &value);
    bool setValueInteger(int value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool createKeyAt(long time);
    bool setValueParameter(const MParameterObjectPtr &src);
    bool setFromParameter(MParameterObjectPtr src);
    bool isConnectable();
    bool isConnected();
    bool setInputParameter(const MParameterObjectPtr &input);
    MParameterObjectPtr getInputParameter();
    MParameterObjectPtr createCopy();

  private:
    MMesh *mesh;
    MAnimMesh *animMesh;
    MEditableMesh *editMesh;

    unsigned int index      : 30;
    bool editMeshCheckDone  : 1;
    bool animMeshCheckDone  : 1;

    bool isEditableMesh();
    bool isAnimMesh();
  };

  class MeshVertexArrayParam : public virtual MArrayParameterAdapter,
                               public MParameterObjectImpl {
  public:
    MeshVertexArrayParam( MMesh *mesh );
    ~MeshVertexArrayParam();
    MBaseObject* getOwner() const;
    void setOwner(MBaseObject *newOwner);
    bool isInputParameter();
    int getElementCount();
    int addElement();
    void removeElement(int index);
    void resize(int size);
    MParameterObjectPtr getElement(int index);
    bool getElement(int index, MStr &value);
    bool getElement(int index, MVector3 &value);
    bool setElement(int index, const MStr &value);
    bool setElement(int index, const MVector3 &value);
    int getElementType() const;

    // MParameterObject methodsfs
    int getDataMeaning() const;
    bool createKeyAt(long time);
    MParameterObjectPtr createCopy();
    bool setValueParameter(const MParameterObjectPtr &src);

  protected:
    MMesh *mesh;
    MEditableMesh *editMesh;

    bool editMeshCheckDone;

    bool isEditableMesh();
  };


}


#endif