#ifndef MBooleanParameter_Header
#define MBooleanParameter_Header

#include <ModelGeneric.h>

namespace Aztec {
  
  class MBooleanParameter;
  typedef MRefCountedPtr<MBooleanParameter> MBooleanParameterPtr;

}

#include <MParameterObject.h>

namespace Aztec {
  
  //--------------------
  //  MBooleanParameter
  //--------------------
  class MGENEXPORT MBooleanParameter : public virtual MParameterObject {
  public:
    virtual bool getValue() = 0;
  };

  class MGENEXPORT MBooleanParameterImpl : public virtual MBooleanParameter,
                                           public MParameterObjectImpl {
  public:
    MBooleanParameterImpl(const MStr &shortName = "", const MStr &longName = "", const MStr &friendlyName = "");
    virtual ~MBooleanParameterImpl();

    // MBooleanParameter methods
    bool getValue();

    // MParameterObject methods.
    int getDataType() const { return TYPE_BOOLEAN; }
    int getDataMeaning() const { return MEANING_ANY; }

    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);

    bool setValueString(const MStr &value);
    bool setValueInteger(int value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool setValueParameter(const MParameterObjectPtr &value);

    MParameterObjectPtr createCopy();

  protected:
    bool    m_Value;
    
  };
}

#endif
