#ifndef MFloatParameter_Header
#define MFloatParameter_Header

#include "ModelGeneric.h"

namespace Aztec {
  
  class MFloatParameter;
  typedef MRefCountedPtr<MFloatParameter> MFloatParameterPtr;

}

#include <MParameterObject.h>

namespace Aztec {
  
  //---------------------------------------
  //  MFloatParameter
  //---------------------------------------
  class MGENEXPORT MFloatParameter : public virtual MParameterObject {
  public:
    virtual float getValue() = 0;
    virtual float getValue(long time) = 0;

  };

  class MGENEXPORT MFloatParameterImpl : public virtual MFloatParameter, 
                                         public MParameterObjectImpl {
  protected:
    float    m_Value;
    
  public:
    MFloatParameterImpl(const MStr &shortName = "", const MStr &longName = "", const MStr &friendlyName = "");
    ~MFloatParameterImpl();

    // MFloatParameter methods
    virtual float getValue();
    virtual float getValue(long time);

    // MParameterObject methods.
    int getDataType() const { return TYPE_FLOAT; }
    int getDataMeaning() const { return MEANING_ANY; }

    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);

    bool setValueString(const MStr &value);
    bool setValueInteger(int value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool setValueParameter(const MParameterObjectPtr &value);

    MParameterObjectPtr createCopy();
    
    // MBaseObject methods
    MStr getClassName() { return MStr("MFloatParameter"); }
  };

}

#endif
