#ifndef MObjectListParameter_Header
#define MObjectListParameter_Header

#include <ModelGeneric.h>

namespace Aztec {
  
  class MObjectListParameter;
  typedef MRefCountedPtr<MObjectListParameter> MObjectListParameterPtr;

}

#include <params/MStringParameter.h>
#include <MNamedObject.h>

#include <vector>
#include <string>

namespace Aztec {
  

  /**
   * This parameter contains a list of objects taht we reference. In the 
   * future, this will be replaced by an array of MObjectParameter's.
   */
  class MGENEXPORT MObjectListParameter : public virtual MStringParameter {
  public:
    virtual void setValue(const std::vector<MNamedObjectPtr> &value) = 0;
    virtual std::vector<MNamedObjectPtr> getValue() = 0;

    virtual int getObjectCount() = 0;
    virtual MNamedObjectPtr getObject(int index) = 0;
    virtual void addObject(MNamedObjectPtr obj) = 0;
    virtual void removeObject(MNamedObjectPtr obj) = 0;
    virtual bool isObjectInList(MNamedObjectPtr obj) = 0;
    
  };

  //---------------------------------------
  //  MObjectListParameter
  //---------------------------------------
  class MGENEXPORT MObjectListParameterImpl : public virtual MObjectListParameter,
                                              public MStringParameterImpl {
  public:
    MObjectListParameterImpl(const MStr &shortName = "", const MStr &longName = "", const MStr &friendlyName = "");
    ~MObjectListParameterImpl();
    
    // MObjectListParameter methods
    void setValue(const std::vector<MNamedObjectPtr> &value);
    std::vector<MNamedObjectPtr> getValue();

    int getObjectCount();
    MNamedObjectPtr getObject(int index);
    void addObject(MNamedObjectPtr obj);
    void removeObject(MNamedObjectPtr obj);
    bool isObjectInList(MNamedObjectPtr obj);
    
    // MParamterObject methods
    bool getValueString(MStr &value);
    bool setValueString(const MStr &value);
    bool setValueParameter(const MParameterObjectPtr &value);

    MParameterObjectPtr createCopy();

    // MBaseObject methods
    MStr getClassName() { return MStr("MObjectListParameter"); }
    
  protected:
    /**
     * This is the std::vector of object pointers.
     */
    std::vector<MNamedObjectPtr> m_Objects;

    /**
     * This is the vector of the names that this time segment controls.
     * This vector is empty if the time segment controls no objects,
     * or if the object pointers are not known. For example, straight
     * after loading from a file, the object may not be known, only its name.
     */
    std::vector<std::string> m_ObjectNames;

    /**
     * This flag indicates if the objects contained in the string
     * names have been located and been placed in the m_Objects vector.
     */
    bool m_ObjectsFound;

    /**
     * This makes sure the object names stored are found
     * and put into the m_Objects member
     *
     * @return true if the objects were found, false othewise.
     */
    bool ensureObjects();

  };

}

#endif
