#ifndef MVector3Parameter_Header
#define MVector3Parameter_Header

#include "MParameterObject.h"
#include "MMath.h"
#include "MNamedObject.h"

#include <vector>
#include <string>

namespace Aztec {
  
  class MVector3Parameter;

  typedef MRefCountedPtr<MVector3Parameter> MVector3ParameterPtr;

  //---------------------------------------
  //  MVector3Parameter
  //---------------------------------------
  class MGENEXPORT MVector3Parameter : public virtual MParameterObject {
  public:
    virtual MVector3 getValue() = 0;
    virtual MVector3 getValue(long time) = 0;

  };
  
  //---------------------------------------
  //  MVector3Parameter
  //---------------------------------------
  class MGENEXPORT MVector3ParameterImpl : public virtual MVector3Parameter,
                                           public MParameterObjectImpl {
  public:
    MVector3ParameterImpl(const MStr &shortName = "", const MStr &longName = "", const MStr &friendlyName = "", int meaning = MEANING_ANY);
    virtual ~MVector3ParameterImpl();

    // MVector3Parameter methods
    MVector3 getValue();
    MVector3 getValue(long time);

    // MParameterObject methods.
    int getDataType() const { return TYPE_VECTOR; }
    int getDataMeaning() const;

    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);

    bool setValueString(const MStr &value);
    bool setValueInteger(int value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool setValueParameter(const MParameterObjectPtr &value);

    MParameterObjectPtr createCopy();

  protected:
    MVector3 m_Value;
    int meaning;    
  };
}

#endif
