#ifndef MSCRIPTINTERP_H
#define MSCRIPTINTERP_H

extern "C" {
#define XP_PC
#include "jsapi.h"
}

#include <string>

#include "ModelGeneric.h"
#include "MSystemManager.h"

#include "scripting/ScriptCallbacks.h"

namespace Aztec {  
	
	// Plugins that want to extend scripting (e.g. add specialized methods to the
	// reflection of their object into JavaScript) should implement a function
	// with this signature within their plugin.  Not mandatory.  Within the plugin
	// it must be named, "ModScripting".
	typedef int (*ScriptingFunc)(JSContext *context, JSObject *globalObject);

	//--------------------------------------------------------------
	// MScriptInterpreter
	//--------------------------------------------------------------
	class MGENEXPORT MScriptInterpreter
	{
	protected:
		JSVersion version;
		JSRuntime *rt;
		JSContext *cx;
		JSObject *global;

		// Startup script interpreter
		bool initFlag;
		void Initialize();

		// Callbacks
		CScriptCallbacks *m_callback;
	public:
		MScriptInterpreter();
		virtual ~MScriptInterpreter();

    static MScriptInterpreter* getInstance();
    static void cleanInstance();
		
		// After loading plugin DLLs, call this to see if any of them extend scripting.
		void extendScripting(MSystemManager *sysMan);

		/// Evaluate a script and return the result
		bool ExecuteScript(const char *Script, std::string &result);

    /// Evaluate a script and disregard the result.
		bool ExecuteScript(const char *Script);

		// Is the string "Script" a valid (executable) JavaScript script?
		bool IsCompilableScript(const char *Script);

		void putCallbacks(CScriptCallbacks *e);
		
		JSContext *GetScriptContext();
		JSObject *GetGlobalObject();

		int PutStr(const char *e);
		void Redraw();
		CScriptCallbacks::actionFunc *GetAction(const char *str);
		CScriptCallbacks::actionFuncWithArgs* getActionWithArgs(const char *str);
	};
}

#endif
