#include "StdAfx.h"

#include "MLineShape.h"
#include <params/MParameterFactory.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  MLineShape::MLineShape(MLineMeshPtr input) {
    m_InMeshParam = MParameterFactory::createObject("inMesh", "inMesh", "Input Mesh");
	  m_InMeshParam->unsetFlag(MParameterObject::FLAG_VISIBLE);
	  
	  addParameter(m_InMeshParam);
	  
	  m_InMeshParam->setValue(input);
  }

  MLineShape::~MLineShape() {
	  
  }

  MLineMeshPtr MLineShape::getLineMesh() {
	  return AZTEC_CAST(MLineMesh, m_InMeshParam->getValue());
  }

  void MLineShape::setLineMesh(MLineMeshPtr mesh) {
	  m_InMeshParam->setValue(mesh);
  }

  MBaseObjectPtr MLineShape::createNew() {
	  MShapeObjectPtr NewObj;
	  
	  NewObj = new MLineShape();
	  NewObj->setFrom(this);
	  
	  return NewObj;
  }

//  MMeshPtr MLineShape::convertToMesh() {
//	  return getMeshObject();
//  }

  bool MLineShape::drawObject(const MBaseObjectPtr &baseObj, MSceneViewFlags ViewFlags) {
	  if (getLineMesh() != NULL) {
		  return getLineMesh()->drawObject(baseObj, ViewFlags);
	  }
	  
	  // if we don't have a mesh, don't draw anything
	  return false;
  }

  MComponentisedObjectPtr MLineShape::getComponentObject() {
    return &*getLineMesh();
  }

  MEditableComponentisedObjectPtr MLineShape::getEditableComponentObject() {
    return &*getLineMesh();
  }
}
