#include "StdAfx.h"

#include <MMeshShape.h>
#include <params/MParameterFactory.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

//--------------
// MMeshShapeObect
//--------------

// Cons truction/Destruction
MMeshShape::MMeshShape(MMeshPtr input) {
  m_InMeshParam = MParameterFactory::createObject("inMesh", "inMesh", "Input Mesh");
	m_InMeshParam->setVisible(false);

	addParameter(m_InMeshParam);

  addParameter(MParameterFactory::createObject("outMesh", "outMesh", "Output Mesh", false));
  findParameter("outMesh")->setInputParameter(findParameter("inMesh"));
  findParameter("outMesh")->setVisible(false);
  
	m_InMeshParam->setValue(input);
}

MMeshShape::~MMeshShape() {
	
}

MMeshPtr MMeshShape::getMeshObject() {
	return AZTEC_CAST(MMesh, m_InMeshParam->getValue());
}

void MMeshShape::setMeshObject(MMeshPtr mesh) {
	m_InMeshParam->setValue(mesh);
}

MBaseObjectPtr MMeshShape::createNew() {
	MMeshShapePtr NewObj;
	
	NewObj = new MMeshShape();
	NewObj->setFrom(this);

  if (getMeshObject() != NULL) {
    NewObj->setMeshObject(AZTEC_CAST(MMesh, getMeshObject()->createNew()));
  }
	
	return NewObj;
}

MMeshPtr MMeshShape::convertToMesh() {
	return getMeshObject();
}

MComponentisedObjectPtr MMeshShape::getComponentObject() {
  return getMeshObject();
}

MEditableComponentisedObjectPtr MMeshShape::getEditableComponentObject() {
  // TODO: add in the ability to create an edit mesh modifier if we don't have an editable mesh
  return AZTEC_CAST(MEditableComponentisedObject, getMeshObject());
}

bool MMeshShape::drawObject(const MBaseObjectPtr &baseObj, MSceneViewFlags ViewFlags) {
	if (getMeshObject() != NULL) {
		return getMeshObject()->drawObject(baseObj, ViewFlags);
	}
	
	// if we don't have a mesh, don't draw anything
	return false;
}


}
