#include "StdAfx.h"
#include "MParameterObject.h"
#include "MBaseObject.h"
#include "MSystemManager.h"

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  const AztecFlags MParameterObject::FLAG_VISIBLE      = OBJECTFLAG_VISIBLE;
  const AztecFlags MParameterObject::FLAG_READONLY     = 0x00000100;
  const AztecFlags MParameterObject::FLAG_CONNECTABLE  = 0x00000200;
  const AztecFlags MParameterObject::FLAG_STORABLE     = 0x00000400;

  bool MParameterObject::isNamed(const MStr &name) {
    // compare all the names first
    if (getShortName().compareNoCase(name) == 0) {
      return true;
    }
    if (getLongName().compareNoCase(name) == 0) {
      return true;
    }
    if (getFriendlyName().compareNoCase(name) == 0) {
      return true;
    }

    // return false if none of the names match
    return false;
  }

  bool MParameterObject::isVisible() { 
    return isFlagged(FLAG_VISIBLE);
  }

  void MParameterObject::setVisible(bool visible) {
    if (visible) {
      setFlag(FLAG_VISIBLE);
    } else {
      unsetFlag(FLAG_VISIBLE);
    }
  }

  bool MParameterObject::isStorable() {
    return isFlagged(FLAG_STORABLE);
  }

  void MParameterObject::setStorable(bool storable) {
    if (storable) {
      setFlag(FLAG_STORABLE);
    } else {
      unsetFlag(FLAG_STORABLE);
    }
  }

  MParameterObjectImpl::MParameterObjectImpl(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName,
    const MParameterObjectPtr &inputParameter) 
  {
    this->shortName = shortName;
    this->longName = longName;
    this->friendlyName = friendlyName;
    this->owner = NULL;
    this->isInputParam = true;

    setInputParameter(inputParameter);

    setVisible(true);
    setStorable(true);
  }
  
  MParameterObjectImpl::~MParameterObjectImpl() {
  }

  void MParameterObjectImpl::setInputParameter(bool input) {
    isInputParam = input;

    // if it is not ian input parameter, then we definately 
    // can't store the result, since it will be calculated anyway.
    if (!isInputParam) {
      setStorable(false);
    }
  }

  MStr MParameterObjectImpl::getShortName() const {
    return shortName;
  }

  MStr MParameterObjectImpl::getLongName() const {
    return longName;
  }

  MStr MParameterObjectImpl::getFriendlyName() const {
    return friendlyName;
  }

  MBaseObject* MParameterObjectImpl::getOwner() const {
    return owner;
  }

  void MParameterObjectImpl::setOwner(MBaseObject *newOwner) {
    owner = newOwner;
  }

  bool MParameterObjectImpl::isInputParameter() {
    return isInputParam;
  }

  bool MParameterObjectImpl::createKeyAt(long time) {
    return false;
  }

  bool MParameterObjectImpl::setFromParameter(MParameterObjectPtr src) {
    setInputParameter(src->getInputParameter());
    isInputParam = src->isInputParameter();

    setValueParameter(src);

    return true;
  }

  bool MParameterObjectImpl::isConnectable() {
    return true;
  }

  bool MParameterObjectImpl::isConnected() {
    return connectedInput != NULL;
  }

  bool MParameterObjectImpl::setInputParameter(const MParameterObjectPtr &input) {
    // if we arne't connectable, then we must do nothing and retunr false.
    if (!isConnectable()) {
      return false;
    }

    // if we are not changing anything, do nothing.
    if (input == connectedInput) {
      return true;
    }

    // disconnect the old input from us, if any.
    if (connectedInput != NULL) {
      removeInput(&*connectedInput);
      connectedInput = NULL;
    }

    bool result = true;

    connectedInput = input;

    MBaseObjectPtr newOwner;
    if (connectedInput != NULL) {
      // We only want to keep track of the input owning object if it is not
      // the same owneras ourselves. If we had the same owner, and then stored
      // that owner, we would produce a circular reference of refcounted ptr's
      // which would cause a memory leak.
      if (input->getOwner() != NULL && getOwner() != input->getOwner()) {
        newOwner = input->getOwner();
      }
      result = addInput(&*connectedInput);
    }

    connectedInputOwner = newOwner;

    return result;
  }

  MParameterObjectPtr MParameterObjectImpl::getInputParameter() {
    return connectedInput;
  }

  bool MParameterObjectImpl::doUpdateObject() {
    MParameterObject::doUpdateObject();

    if (isConnected()) {
      setValueParameter(getInputParameter());
    }

    unsetFlag(OBJECTFLAG_NEEDS_UPDATE);
    return true;
  }


}