%{
// This first section contains C code which will be included in the output
// file.
#include <stdlib.h>
#include <string.h>

#include "keyval.h"

static CValueType yyval;
int yywrap()
{
	return 1;
}
%}

white	[ \t]+
integer [0-9]+
dreal	[0-9]+([.]?[0-9]*(e[\-\+]?[0-9]+)?)?
ereal	[0-9]*([.]?[0-9]+(e[\-\+]?[0-9]+)?)?
real	{dreal}|{ereal}
boolean	"true"|"false"
qstring	\"[^\"\n]*\"
id		[_a-zA-Z][\._a-zA-Z0-9]*

%%
{white}		;
-{integer}	{ yyval.ival = atoi(yytext); return KEYVAL_TYPE_INTEGER; }
{integer}	{ yyval.ival = atoi(yytext);  return KEYVAL_TYPE_INTEGER; }
-{real}		{ yyval.dval = atof(yytext); return KEYVAL_TYPE_FLOAT; }
{real}		{ yyval.dval = atof(yytext); return KEYVAL_TYPE_FLOAT; }
{boolean}	{ yyval.ival = (!strcmp(yytext, "true") ? 1 : 0); return KEYVAL_TYPE_BOOLEAN; }
{qstring}	{ yyval.sval = yytext; return KEYVAL_TYPE_STRING; }
{id}		{ yyval.sval = yytext; return KEYVAL_TYPE_STRING; }
%%

int getValueType(const char *str, CValueType *val)
{
	int result;
	yy_scan_string(str);

	result = yylex();

	if (val == YY_NULL) {
		return KEYVAL_TYPE_UNKNOWN;
	} else {
		*val = yyval;
		return result;
	}
}

#if 0
// Sample driver code - parses a single thing from the command line
int main(int argc, char **argv)
{
	int val;
	char str[1024];

	gets(str);
	str[strlen(str)] = '\0';

	val = getValueType(str);
	if (val == KEYVAL_TYPE_INTEGER)
		printf("integer: %d\n", yyval.ival);
	else if (val == KEYVAL_TYPE_FLOAT)
		printf("float: %g\n", yyval.dval);
	else if (val == KEYVAL_TYPE_BOOLEAN)
		printf("bool: %s\n", (yyval.ival ? "true" : "false"));
	else if (val == KEYVAL_TYPE_STRING)
		printf("string: %s\n", yyval.sval);
	else
		printf("Unknown token type\n");

	return val;
}
#endif
