#include "StdAfx.h"

#include "scripting/ScriptVectorParam.h"
#include "scripting/MScriptInterp.h"
#include "scripting/ScriptUtils.h"

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {  


class AztecParam {
public:
	// We need to initialize referenced variables like shown below
	// to keep GCC 3.2 happy
	AztecParam(MNamedObjectPtr obj=NULL, MParameterObjectPtr prm=NULL)
		 : parent(obj), param(prm) {
	}

	MNamedObjectPtr &parent;
	MParameterObjectPtr &param;
};


static JSBool
aztecVectorLength(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
{
	AztecParam *param = (AztecParam *)JS_GetPrivate(cx, obj);
	if (param == NULL) {
		return JS_FALSE;
	}
	MVector3 vec;
	param->param->getValueVector(vec);

	return JS_NewDoubleValue(cx, vec.length(), rval);
}

static JSPropertySpec aztecVector_props[] = {
	{"x",	0,	JSPROP_ENUMERATE},
	{"y",	1,	JSPROP_ENUMERATE},
	{"z",	2,	JSPROP_ENUMERATE},
	{0}
};

static JSFunctionSpec aztecVector_methods[] = {
	{"length",	aztecVectorLength,	0},
	{0}
};

static JSBool
aztecVector_getProperty(JSContext *cx, JSObject *obj, jsval id, jsval *vp)
{
	AztecParam *param = (AztecParam *)JS_GetPrivate(cx, obj);
	if (param == NULL || param->param == NULL) {
		return JS_FALSE;
	}

	// If we are working from a parameter, then pull the current value
	// and use it.  Otherwise used the vector we are dragging around
	// inside this object.
	MVector3 vec;
	param->param->getValueVector(vec);

	if (JSVAL_IS_STRING(id)) {
		char *propStr = JS_GetStringBytes(JS_ValueToString(cx, id));
		if (strcmp(propStr, "x") == 0) {
			return JS_NewDoubleValue(cx, vec.x, vp);
		} else if (strcmp(propStr, "y") == 0) {
			return JS_NewDoubleValue(cx, vec.y, vp);
		} else if (strcmp(propStr, "z") == 0) {
			return JS_NewDoubleValue(cx, vec.z, vp);
		} else {
			return JS_TRUE;
		}
	} else if (JSVAL_IS_INT(id)) {
		int index = JSVAL_TO_INT(id);
		if (index == 0) {
			return JS_NewDoubleValue(cx, vec.x, vp);
		} else if (index == 1) {
			return JS_NewDoubleValue(cx, vec.y, vp);
		} else if (index == 2) {
			return JS_NewDoubleValue(cx, vec.z, vp);
		} else {
			return JS_TRUE;
		}
	} else if (JSVAL_IS_OBJECT(id)) {
		char *propStr = JS_GetStringBytes(JS_ValueToString(cx, id));
		OutputDebugString("Vec prop: ");
		OutputDebugString(propStr);
		OutputDebugString("\n");
		return JS_FALSE;
	} else {
		char *propStr = JS_GetStringBytes(JS_ValueToString(cx, id));
		OutputDebugString("Vec prop: ");
		OutputDebugString(propStr);
		OutputDebugString("\n");
		return JS_FALSE;
	}
}

static void
updateAztecVector(JSContext *cx, AztecParam *param, MVector3 &vec)
{
	param->param->setValueVector(vec);
	updateParamObject(param->parent);

	MScriptInterpreter *interp = (MScriptInterpreter *)JS_GetContextPrivate(cx);
}

static JSBool
aztecVector_setProperty(JSContext *cx, JSObject *obj, jsval id, jsval *vp)
{
	AztecParam *param = (AztecParam *)JS_GetPrivate(cx, obj);
	if (param == NULL || param->param == NULL) {
		return JS_FALSE;
	}

	double t;
	if (JSVAL_IS_INT(*vp)) {
		t = JSVAL_TO_INT(*vp);
	} else if (JSVAL_IS_DOUBLE(*vp)) {
		t = *JSVAL_TO_DOUBLE(*vp);
	} else if (JSVAL_IS_BOOLEAN(*vp)) {
		t = (JSVAL_TO_BOOLEAN(*vp) ? 1.0 : 0.0);
	} else if (JSVAL_IS_STRING(*vp)) {
		char *valStr = JS_GetStringBytes(JS_ValueToString(cx, *vp));
		t = atof(valStr);
	} else {
		return JS_FALSE;
	}

	MVector3 vec;
	param->param->getValueVector(vec);

	if (JSVAL_IS_STRING(id)) {
		char *propStr = JS_GetStringBytes(JS_ValueToString(cx, id));
		if (strcmp(propStr, "x") == 0) {
			vec.x = t;
			updateAztecVector(cx, param, vec);
			return JS_TRUE;
		} else if (strcmp(propStr, "y") == 0) {
			vec.y = t;
			updateAztecVector(cx, param, vec);
			return JS_TRUE;
		} else if (strcmp(propStr, "z") == 0) {
			vec.z = t;
			updateAztecVector(cx, param, vec);
			return JS_TRUE;
		} else {
			return JS_FALSE;
		}
	} else if (JSVAL_IS_INT(id)) {
		int index = JSVAL_TO_INT(id);
		if (index == 0) {
			vec.x = t;
			updateAztecVector(cx, param, vec);
			return JS_TRUE;
		} else if (index == 1) {
			vec.y = t;
			updateAztecVector(cx, param, vec);
			return JS_TRUE;
		} else if (index == 2) {
			vec.z = t;
			updateAztecVector(cx, param, vec);
			return JS_TRUE;
		} else {
			return JS_FALSE;
		}
	} else if (JSVAL_IS_OBJECT(id)) {
		char *propStr = JS_GetStringBytes(JS_ValueToString(cx, id));
		OutputDebugString("Vec prop: ");
		OutputDebugString(propStr);
		OutputDebugString("\n");
		return JS_FALSE;
	} else {
		char *propStr = JS_GetStringBytes(JS_ValueToString(cx, id));
		OutputDebugString("Vec prop: ");
		OutputDebugString(propStr);
		OutputDebugString("\n");
		return JS_FALSE;
	}
}

static JSBool
aztecVector_convert(JSContext *cx, JSObject *obj, JSType typ, jsval *vp)
{
	AztecParam *param = (AztecParam *)JS_GetPrivate(cx, obj);
	if (param == NULL || param->param == NULL) {
		return JS_FALSE;
	}
	
    switch (typ) {
    case JSTYPE_OBJECT:
        *vp = OBJECT_TO_JSVAL(obj);
        return JS_TRUE;
		
    case JSTYPE_VOID:
    case JSTYPE_STRING:
		{
			char buf[128];
			MVector3 vec;
			param->param->getValueVector(vec);
			sprintf(buf, "{%f,%f,%f}", vec.x, vec.y, vec.z);
			JSString *str = JS_NewStringCopyZ(cx, buf);
			*vp = STRING_TO_JSVAL(str);
			return JS_TRUE;
		}
		
	case JSTYPE_FUNCTION:
	case JSTYPE_NUMBER:
    case JSTYPE_BOOLEAN:
    default:
        return JS_FALSE;
    }
}

static void
aztecVector_finalize(JSContext *cx, JSObject *obj)
{
	AztecParam *param = (AztecParam *)JS_GetPrivate(cx, obj);
	if (param == NULL) {
		return;
	}

	delete param;
}

/*JSClass aztecVector_class = { 
	"AztecVector", JSCLASS_HAS_PRIVATE, 
		JS_PropertyStub, JS_PropertyStub,					// add/del property
		aztecVector_getProperty, aztecVector_setProperty,	// get/set property
		JS_EnumerateStub, JS_ResolveStub,
		aztecVector_convert, aztecVector_finalize
};*/

JSObject *newVectorParam(JSContext *cx, JSObject *obj,
						 MNamedObject *aztec_obj, MParameterObject *aztec_param)
{
	JSObject *jsvec = JS_NewObject(cx, &aztecVector_class, NULL, obj);
	AztecParam *vparm = new AztecParam;
	vparm->parent = aztec_obj;
	vparm->param = aztec_param;
	JS_SetPrivate(cx, jsvec, vparm);

	return jsvec;
}

void addVectorParamClass(JSContext *cx, JSObject *obj)
{
	// Add a vector class (reflection of MVector3) to the global namespace
    JS_InitClass(cx, obj, NULL, &aztecVector_class, 0, 0,
		aztecVector_props, aztecVector_methods, 0, 0);

}

}
