#ifndef AztecImageViewer_Header
#define AztecImageViewer_Header

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <controls/ImageButton.h>

class ImageViewer : public CWnd
{
// Construction
public:
  BOOL Create(const CRect &rect, CWnd *parent, bool visible = true);
	ImageViewer();

  void setImage(const MImagePtr newImage);
  MImagePtr getImage();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(ImageViewer)
	protected:
	virtual void PreSubclassWindow();
	//}}AFX_VIRTUAL

// Implementation
public:
  virtual ~ImageViewer();
  
	// Generated message map functions
protected:
  CRect    imageRect;

  MImagePtr image;
  MDIBImage imageToPaint;

  void SendMessageToParent(int Message);
  void doScroll(UINT scrollBar, UINT nSBCode, UINT nPos);

    //{{AFX_MSG(ImageViewer)
	afx_msg void OnPaint();
	afx_msg UINT OnNcHitTest(CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
  afx_msg void OnHScroll( UINT nSBCode, UINT nPos, CScrollBar* pScrollBar );
  afx_msg void OnVScroll( UINT nSBCode, UINT nPos, CScrollBar* pScrollBar );

	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_COLORWHEEL_H__CB890489_A818_4B4C_A8AE_6459FBD96385__INCLUDED_)
