// AztecMainDlg.h : header file
//

#if !defined(AFX_AZTECMAINDLG_H__D4A35A69_C189_11D2_8361_0040332C7B2F__INCLUDED_)
#define AFX_AZTECMAINDLG_H__D4A35A69_C189_11D2_8361_0040332C7B2F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ATabCtrl.h"      // AutoTabControl

#include "SegmentEditor.h"
#include "BottmDlg.h"      // Bottom Dialog
#include "TopToolDlg.h"    // Top Dialog

#include "ChannelBar.h"    // Cannel Box control
#include "ConDlg.h"        // Console Output

#include "BaseViewWnd.h"
#include "MShelfManager.h"

#include "MdlConst.h"	// Added by ClassView

#if USE_SPACEBALL
#define OS_WIN32
extern "C" {
#include "si.h"
#include "siapp.h"
}
#endif

/////////////////////////////////////////////////////////////////////////////
// CAztecMainDlg dialog

class CAztecMainDlg : public CDialog
{
// Construction
public:
	UINT IsMenuChecked(UINT IDItem);
   UINT ToggleMenuChecked(UINT IDItem);
	void MouseDown(MShiftState Shift, int X, int Y);
   void MouseUp(MShiftState Shift, int X, int Y);
	void SaveConfigToReg();
	void LoadConfigFromReg();
	void DoViewPortSize();
	void CalcViewportWidthHeight();
	void DoResize();
	void WasOnShowWindow();
	CAztecMainDlg(CWnd* pParent = NULL);	// standard constructor
   RECT GetViewportsRect();
   bool tryAccellerator(UINT nChar, UINT nRepCnt, UINT nFlags);	// Return false if no accellerator for this key

// 
   bool m_Ready,m_Closing, m_MidPointMoveX, m_MidPointMoveY;

// Dialog Data
	//{{AFX_DATA(CAztecMainDlg)
	enum { IDD = IDD_AZTECMAIN_DIALOG };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAztecMainDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
protected:

public:
	void UpdateMenuMRU();
	void AddToMRUList(MStr Str);
	HICON	         m_hIcon;
   
   CBottomDlg     m_BottomToolDlg;
   CTopToolDlg    m_TopToolDlg;
   CChannelBarContainer *m_ChannelBar;


   float          m_MidpointX, m_MidpointY;                 // midpoint, as fraction of 1.0
   int            m_VWidthL, m_VWidthR, m_VHeightT, m_VHeightB;     // various window measurements
   int            m_VWidthL2, m_VWidthR2, m_VHeightT2, m_VHeightB2; // same as above, but halved

//   CDrawViewInfo  m_DrawInfo;
   MShiftState    m_ShiftState;

   UINT           m_PlayTimerID;
   MShiftState    m_KeyState;
   HMENU          m_hMaterialsMenu, m_hPrimitivesMenu;

   CConsoleDlg    m_ConsoleDlg;
   MShelfManager  m_ShelfMan;

#if USE_SPACEBALL
	SiHdl m_DevHdl; /* Handle to 3DxWare Device */
#endif

	// Generated message map functions
	//{{AFX_MSG(CAztecMainDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnWindowPosChanged(WINDOWPOS FAR* lpwndpos);
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnClose();
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnEditCopyselected();
	afx_msg void OnEditPaste();
	afx_msg void OnEditPastetorange();
	afx_msg void OnEditChangeframename();
	afx_msg void OnEditGotoframe();
	afx_msg void OnEditAddnewframe();
	afx_msg void OnEditMoveframes();
	afx_msg void OnEditDeletecurrentframe();
	afx_msg void OnEditDeleteframes();
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_AZTECMAINDLG_H__D4A35A69_C189_11D2_8361_0040332C7B2F__INCLUDED_)
