#ifndef MSelectTool_Header
#define MSelectTool_Header

#include <MToolType.h>

//-------------------
//  MSelectToolType
//-------------------
class MSelectToolType : public MToolType
{
protected:
   bool     m_Selecting, m_Deselecting, m_BoxSelect;

public:
   MSelectToolType();

   // MToolType methods

   void initialise();

   /**
    * Cancelling this tool does several things:
    * <ul>
    * <li>If we are in object mode, then cancelling clears the current 
    *     selection.</li>
    * <li>If we are in component mode, cancelling clears the current 
    *     selection. If there are no components selected, we go to object 
    *     mode.</li>
    * </ul>
    */
   bool cancel();

   int DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View);
   int onMouseDown(int X, int Y, const MShiftState &Shift);
   int onMouseUp(int X, int Y, const MShiftState &Shift);
   int onMouseMove(int X, int Y, const MShiftState &Shift);

private:
  /**
   * This is used to keep track if the user has just cancelled. If they have, 
   * then the current selection has been cleared. If we cancel twice in a row
   * then we have to go back to object mode.
   */
  bool justCancelled;
};


#endif