#ifndef MFormViewWnd_Header
#define MFormViewWnd_Header

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "BaseViewWnd.h"

class MFormView : public MBaseViewWnd
{
// Construction
public:
  class ActionListener : public MRefCountedObject {
  public:
    virtual void onAction(MFormView *form, const std::string &action) = 0;
  };
  typedef MRefCountedPtr<ActionListener> ActionListenerPtr;



	MFormView();
	~MFormView();

  /**
   * This retrieves the window that users of the view should add controls to.
   */
  CWnd* getContentPane();

  void addButton(const std::string &caption);

  /**
   * This method is called when the user clicks on one of the form buttons at 
   * the bottom of the window.
   */
  virtual void onFormAction(const std::string &action);

  /**
   * Call this to force a layout of the components.
   */
  void doLayout();

  /**
   * Adds a listener that is called whenever a form action button (Ok, Cancel, 
   * apply etc) is pressed.
   */
  void addActionListener(const ActionListenerPtr &listener);

  // MBaseViewWnd methods
  virtual void ViewCreate();
  virtual void DrawView();
  
  virtual DWORD ViewPopupMenu(int x, int y);
  virtual int HandlePopupCommand(DWORD Cmd);

  // MBaseObject methods
  virtual MStr getClassName() {return MStr("FormViewWnd");};
  virtual MStr getParentClassName() {return MStr("MBaseViewWnd");};
  virtual MBaseObjectPtr createNew();

private:
  CWnd *contentPane;

  class CButtonPane : public CWnd {
  public:
    CButtonPane(MFormView *parent);
  	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

  private:
    MFormView *parent;
  };
  CButtonPane *buttonPane;

  std::vector<CButton*> buttons;
  typedef std::vector<ActionListenerPtr> ListenerList;
  ListenerList listeners;

  void layoutButtons();


public:
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(MFormView)
public:
  virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:

	// Generated message map functions
protected:
	//{{AFX_MSG(MFormView)
	afx_msg void OnClose();
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif
