#if !defined(AFX_OPENGLWND_H__EEE8D9F6_F3BE_11D2_83F3_0040332C7B2F__INCLUDED_)
#define AFX_OPENGLWND_H__EEE8D9F6_F3BE_11D2_83F3_0040332C7B2F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MMath.h"

#include <gl/gl.h>

#include "BaseViewWnd.h"
#include "BaseOpenGLWnd.h"
#include <MZoomableWindow.h>

#include <MCamera.h>

#if USE_SPACEBALL
#define OS_WIN32
extern "C" {
#include "si.h"
#include "siapp.h"
}
#endif

class COpenGLWnd;

typedef MRefCountedPtr<COpenGLWnd> COpenGLWndPtr;

//----------------------------------------------------------------------------------------
//  COpenGLWnd
//----------------------------------------------------------------------------------------
class COpenGLWnd : public MBaseOpenGLWnd, public MZoomableWindow {
// Construction
public:
	COpenGLWnd();

    // Class related
   virtual MStr getClassName() {return MStr("COpenGLWnd");};
   virtual MStr getParentClassName() {return MStr("MBaseViewWnd");};
   virtual MBaseObjectPtr createNew();   

   virtual void ViewCreate();
   virtual void DrawView();
   void drawView(MSelectMethod method,
                 std::vector<MSelectionItem> *selectResultList = NULL, 
                 int left = -1, int top = -1, 
                 int right = -1, int bottom = -1);

   void SetGridBasis(const MVector3 &X, const MVector3 &Y);
   void getGridBasis(MVector3 &x, MVector3 &y);
   MPlane getGridPlane();

   void performSelection(int x, int y, 
                         std::vector<MSelectionItem> *list);

   void performSelection(int left, int top, 
                         int right, int bottom, 
                         std::vector<MSelectionItem> *list);

   // BaseViewWnd methods
   MToolTypePtr getSelectTool();
   bool isAnythingSelected();

  // MZoomableWindow methods
  void zoomIn();
  void zoomOut();
  void zoomToFitAll();
  void zoomToFitSelected();


   MVector3       m_Pan, m_Rot;
	float          m_Zoom, m_Dist, m_Persp;

protected:
#if USE_SPACEBALL
	void processSpaceballMovement(SiSpwEvent *event, SiGetEventData *eData);
#endif

public:
   MVector3       m_GridBasisX, m_GridBasisY;

   GLShadingMode  m_ShadingMode;
   GLTextureMode m_TexturingMode;
   GLLightingMode m_LightingMode;
   int            m_TextureMode;

   MActionType    m_Action;

   GLuint         *m_TextureNames;
   int            m_NumTextureNames;

   MSceneObjectPtr camera;

#if USE_SPACEBALL
	SiHdl m_DevHdl; /* Handle to 3DxWare Device */
#endif

   // MBaseOpenGLWnd methods
   virtual void AdjustProjectionMatrix(MSelectMethod PickMode = smNone, 
                                       int left = -1, int top = -1,
                                       int right = -1, int bottom = -1);
   virtual void DoViewportTransform();
   virtual void UpdateXFormMatricies();
   virtual void AdjustScaleFactor();
   virtual float GetScaleFactor(const MVector3 &Vec);
   virtual void DrawViewExtras();

   // MBaseViewWnd methods
   virtual DWORD ViewPopupMenu(int x, int y);
   virtual int HandlePopupCommand(DWORD Cmd);

   // Draws anything in the view that goes on top of everything else, eg View Labels
   // or anything that is drawn in screen space
   // Draws the manipulators for the current tool in the corect plance. If Select == true, then 
   // The manipulatros are drawn using glRenderMode(GL_SELECT)
   int DrawManipulators(bool Select);
   // Draws a Grid using the two vextors as a basis for the grid coordinate system.
   void DrawGrid(const MVector3 &BX, const MVector3 &BY);

   void glRotateCamera();

   // Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COpenGLWnd)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
  // MBaseViewWnd methods
	virtual void onMouseUp(int X, int Y, MShiftState Shift);
	virtual void onMouseDown(int X, int Y, MShiftState Shift);
  virtual void onMouseMove(int x, int y, MShiftState Shift);
	virtual ~COpenGLWnd();

	// Generated message map functions
protected:
	//{{AFX_MSG(COpenGLWnd)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnClose();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
};



/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_OPENGLWND_H__EEE8D9F6_F3BE_11D2_83F3_0040332C7B2F__INCLUDED_)
