#ifndef RenderView_Header
#define RenderView_Header

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <params/MKeyParameter.h>
#include <params/MVector3KeyParameter.h>

#include "BaseViewWnd.h"
#include "BaseOpenGLWnd.h"
#include <controls/ImageViewer.h>
#include <views/MZoomableWindow.h>

#include <map>

class RenderView : public MBaseViewWnd, public MZoomableWindow
{
// Construction
public:
  RenderView();
  
  // Class related
  virtual MStr getClassName() {return MStr("RenderView");};
  virtual MStr getParentClassName() {return MStr("MBaseViewWnd");};
  virtual MBaseObjectPtr createNew();
  
  virtual void ViewCreate();
  virtual void DrawView();
  
  virtual DWORD ViewPopupMenu(int x, int y);
  virtual int HandlePopupCommand(DWORD Cmd);

  ImageViewer* getImageComponent();

  void doZoomToFit(bool doSelection);

  // MBaseViewWnd methods
  void onMouseDown(int x, int y, MShiftState Shift);
  void onMouseUp(int x, int y, MShiftState Shift);
  void onMouseMove(int x, int y, MShiftState Shift);
  void onSize();

  // MZoomableWindow methods
  void zoomIn();
  void zoomOut();
  void zoomToFitAll();
  void zoomToFitSelected();

private:
  HDC paintDC;
  ImageViewer *imageViewer;

  void saveCurrentImage();

public:
  // Overrides
  // ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(RenderView)
  virtual BOOL OnCommand( WPARAM wParam, LPARAM lParam );
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~RenderView();

	// Generated message map functions
protected:
	//{{AFX_MSG(RenderView)
	afx_msg void OnClose();
	afx_msg void OnPaint();
  afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TRACKVIEWWND_H__49925471_455F_11D3_9A66_0040332C7B2F__INCLUDED_)
