// ConDlg.cpp : implementation file
//

#include <AztecMainPCH.h>
#include <controls/AztecSplashScreen.h>

#include <DlgGlobs.h>
#include "MainFunc.h"
#include <AztecVersion.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AztecSplashScreen dialog


AztecSplashScreen::AztecSplashScreen()
{
	//{{AFX_DATA_INIT(AztecSplashScreen)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

BEGIN_MESSAGE_MAP(AztecSplashScreen, CWnd)
	//{{AFX_MSG_MAP(AztecSplashScreen)
	ON_WM_WINDOWPOSCHANGED()
  ON_WM_CLOSE()
  ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// AztecSplashScreen message handlers

static AztecSplashScreen *splash = NULL;

void AztecSplashScreen::createSplash() {
  RECT desktopRect;
  RECT rect = { 200,200,400,300 } ;
  BITMAP bm;

  ::GetWindowRect(::GetDesktopWindow(), &desktopRect);

  splash = new AztecSplashScreen();

  std::string imageFilename;

  // initialise the program settings so we can get our preferences directory.
  { 
    MStr directory;

    char buf[512];
    ::GetModuleFileName(NULL, buf, 512);
    directory = buf;
    MStr drive,dir;
    directory.SplitPath(&drive,&dir,NULL,NULL);
    directory = drive+dir;

    imageFilename = directory.c_str();
    imageFilename += "../../common/prefs/splash.bmp";
  }

  splash->mBitmap = (HBITMAP)LoadImage(GetModuleHandle(NULL), imageFilename.c_str(), IMAGE_BITMAP, 0,0, LR_LOADFROMFILE);
  DWORD err = 0;

  int width = 0;
  int height = 0;
  if (splash->mBitmap == 0) {
    err = ::GetLastError();
  } else {
    ::GetObject(splash->mBitmap, sizeof(bm), &bm);
    width = bm.bmWidth;
    height = bm.bmHeight;
  }

  int centreX = 0.5 * (desktopRect.right + desktopRect.left);
  int centreY = 0.5 * (desktopRect.bottom + desktopRect.top);

  rect.left = centreX - width / 2;
  rect.right = rect.left + width;

  rect.top = centreY - height / 2;
  rect.bottom = rect.top + height;

#ifdef _DEBUG
  splash->CreateEx(0, AfxRegisterWndClass(0), "AztecSplashScreen", WS_POPUP, rect, NULL, 0);
#else
  splash->CreateEx(WS_EX_TOOLWINDOW, AfxRegisterWndClass(0), "AztecSplashScreen", WS_POPUP, rect, NULL, 0);
#endif
  splash->ShowWindow(SW_SHOW);

  splash->initSystem();
}

void AztecSplashScreen::cleanupSplash() {
  if (splash != NULL) {
    ::DeleteObject(splash->mBitmap);
    splash->DestroyWindow();
    delete splash;
    splash = NULL;
  }
}


void AztecSplashScreen::OnWindowPosChanged(WINDOWPOS FAR* lpwndpos) 
{
	CWnd::OnWindowPosChanged(lpwndpos);
  resizeControls();
}

void AztecSplashScreen::resizeControls(bool adjustSplitPos) {	
/*
   RECT  WndClientRect, OutputRect;
   int outputHeight = 15;
   GetClientRect(&WndClientRect);
   m_OutputEdit.GetWindowRect(&OutputRect);
   m_OutputEdit.ScreenToClient(&OutputRect);

   outputHeight = OutputRect.bottom - OutputRect.top;

   m_OutputEdit.MoveWindow(
     1,
     1 , 
     WndClientRect.right-2, 
     outputHeight);
*/
}

void AztecSplashScreen::OnClose() {
  doneInitSystem();
}

void AztecSplashScreen::OnPaint() {
  PAINTSTRUCT paint;
  CDC *dc = BeginPaint(&paint);

  RECT clientRect;
  RECT fontRect;

  GetClientRect(&clientRect);
  GetClientRect(&fontRect);


  CDC hdcMem;
  hdcMem.CreateCompatibleDC(dc);
  CBitmap *newBitmap = CBitmap::FromHandle(splash->mBitmap);
  CBitmap *old = hdcMem.SelectObject(newBitmap);

  BITMAP bm;
  GetObject(splash->mBitmap, sizeof(bm), &bm);

  dc->BitBlt(0,0, bm.bmWidth,bm.bmHeight, &hdcMem, 0,0, SRCCOPY);

  hdcMem.SelectObject(old);
  hdcMem.DeleteDC();


  HFONT oldFont;
  HFONT hFont;
  std::string text;

  dc->SetBkMode(TRANSPARENT);
  dc->SetTextColor(RGB(255,255,255));

  text = "Version ";
  text += AZTEC_VERSION_NUMBER;
  hFont = ::CreateFont(14, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "Verdana");
  oldFont = (HFONT)::SelectObject(dc->m_hDC, hFont);
  fontRect.top = 214;
  ::DrawText(dc->m_hDC, text.c_str(), text.length(), &fontRect, DT_CENTER);
  ::SelectObject(dc->m_hDC, oldFont);
  ::DeleteObject(hFont);

  dc->SetTextColor(RGB(0,0,0));

  // TODO: Replace with dynamically updated DLL name being loaded (text ctrl?)
  text = "Loading..."; // <name>.dll...";
  hFont = ::CreateFont(14, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "Verdana");
  oldFont = (HFONT)::SelectObject(dc->m_hDC, hFont);
  fontRect.top = 258;
  ::DrawText(dc->m_hDC, text.c_str(), text.length(), &fontRect, DT_CENTER);
  ::SelectObject(dc->m_hDC, oldFont);
  ::DeleteObject(hFont);


  EndPaint(&paint);
}

DWORD WINAPI staticInitSystem(LPVOID arg) {

  InitialiseGlobals();

  splash->SendMessage(WM_CLOSE);
  return 0;
}


void AztecSplashScreen::initSystem() {
  DWORD threadId;
  CreateThread(NULL, 0, staticInitSystem, NULL, 0, &threadId);
}

void AztecSplashScreen::doneInitSystem() {
  g_MainDlg->Create(CAztecMainDlg::IDD);
  g_MainDlg->ShowWindow(SW_SHOW);

  cleanupSplash();
}

