// DottmDlg.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "resource.h"
#include "MDLGlobs.h"
#include "BottmDlg.h"

#include "MdlMsgs.h"
#include "MainFunc.h"

#include "KeyFuncMain.h"
#include "KeyfuncAnim.h"

#include "UndoGeneral.h"

#include <MUIManager.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBottomDlg dialog

#define GetDlgButton(D,R)     ((CButton*)D->GetDlgItem(R))

class SingleLineEditListener : public MLogFileListener { 
public:

  SingleLineEditListener(HWND hWnd) 
    : hWnd(hWnd)
  {
    clearLineForNextTime = true;
  }

  void writeString(MLogFile *logfile, const std::string &text) {
    // if we have to clear the line, then just use the write line method,
    // otherwise we append to the current line.
    if (clearLineForNextTime) {
      writeLine(logfile, text);
      clearLineForNextTime = false;
    } else {
      // however, if we have a end of line character in the text,
      // then we have to only use what is after that
      int endOfLineIndex = text.rfind('\n');

      if (endOfLineIndex != std::string::npos && endOfLineIndex == text.length() - 1) {
        // only set the text to what appears after the end of line character.
        std::string line = text.substr(endOfLineIndex+1);

        // only bother doing anything if there is anything on the 
        // line worth doing
        if (line.length() > 0) {
          ::SetWindowText(hWnd, line.c_str());
        }
        clearLineForNextTime = true;

      } else {
        clearLineForNextTime = true;
        // otherwise, we append what we have to the current text.
        char buf[1024];
        ::GetWindowText(hWnd, buf, 1024);

        std::string result = buf + text;
        ::SetWindowText(hWnd, result.c_str());
      }
    }
  }
  
  void writeLine(MLogFile *logfile, const std::string &text) {
    int endOfLineIndex = text.rfind('\n');

    // only set the text to what appears after the end of line character.
    ::SetWindowText(hWnd, text.substr(endOfLineIndex+1).c_str());

    clearLineForNextTime = true;
  }

private:
  HWND hWnd;
  bool clearLineForNextTime;
};


CBottomDlg::CBottomDlg(CWnd* pParent /*=NULL*/)
: CDialog(CBottomDlg::IDD, pParent)
{
  //{{AFX_DATA_INIT(CBottomDlg)
  //}}AFX_DATA_INIT
  m_TimeScroll.setEditBoxes(&m_StartEdit, &m_EndEdit);
}


void CBottomDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //	DDX_Control(pDX, IDC_TIMESCROLL, m_TimeScroll);
  //{{AFX_DATA_MAP(CBottomDlg)
	DDX_Control(pDX, IDC_STARTEDIT, m_StartEdit);
	DDX_Control(pDX, IDC_ENDEDIT, m_EndEdit);
  DDX_Control(pDX, IDC_SINGLELINEOUTPUTEDIT, m_SingleLineOutputEdit);
  DDX_Control(pDX, IDC_PREVKEYFRAMEBUT, m_PrevKeyBut);
  DDX_Control(pDX, IDC_PREVFRAMEBUT, m_PrevFrameBut);
  DDX_Control(pDX, IDC_PLAYBUT, m_PlayBut);
  DDX_Control(pDX, IDC_NEXTKEYFRAMEBUT, m_NextKeyBut);
  DDX_Control(pDX, IDC_NEXTFRAMEBUT, m_NextFrameBut);
  DDX_Control(pDX, IDC_CURTIMEEDIT, m_CurTimeEdit);
  DDX_Control(pDX, IDC_COORD_FEEDBACK, m_FeedbackEdit);
	//}}AFX_DATA_MAP
  
  m_PlayBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\Play.bmp");
  m_NextFrameBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\ffwd.bmp");
  m_PrevFrameBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\rewind.bmp");
  m_NextKeyBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\keynext.bmp");
  m_PrevKeyBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\keyPrev.bmp");
  
  m_PrevFrameBut.SetActionName("KControlPrevFrame");
  m_NextFrameBut.SetActionName("KControlNextFrame");
  m_PlayBut.SetActionName("KControlPlayCamera");
  
  m_NextFrameBut.setRepeatable(true);
  m_PrevFrameBut.setRepeatable(true);
  m_NextKeyBut.setRepeatable(true);
  m_PrevKeyBut.setRepeatable(true);

  coordinateListener = new CoordinateListener(&m_FeedbackEdit);
  MUIManager::addListener(MUIManager::COORDINATE_FEEDBACK_LISTENER, coordinateListener);

  // add in the listener so our single line edit control recieves text notifcation events.
  g_SysMan->getLogger()->addListener(new SingleLineEditListener(m_SingleLineOutputEdit.m_hWnd));

}


BEGIN_MESSAGE_MAP(CBottomDlg, CDialog)
//{{AFX_MSG_MAP(CBottomDlg)
ON_WM_WINDOWPOSCHANGED()
ON_WM_HSCROLL()
ON_WM_CREATE()
	ON_EN_CHANGE(IDC_STARTEDIT, OnChangeStartedit)
	ON_EN_CHANGE(IDC_ENDEDIT, OnChangeEndedit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBottomDlg message handlers

void CBottomDlg::OnWindowPosChanged(WINDOWPOS FAR* lpwndpos) 
{
  CDialog::OnWindowPosChanged(lpwndpos);
  
  RECT     clientRect;
  
  GetClientRect(&clientRect);
  
  m_StartEdit.MoveWindow(3, 6, 40, 22);
  m_EndEdit.MoveWindow(clientRect.right - clientRect.left - 185 - 40, 6, 40, 22);

  m_TimeScroll.MoveWindow(46 ,6,clientRect.right-6-clientRect.left-185 - 45 - 36, 24);
  
  GetDlgButton(this, IDC_PREVKEYFRAMEBUT)->MoveWindow(clientRect.right - 180, 6, 24,24);
  GetDlgButton(this, IDC_PREVFRAMEBUT)->MoveWindow(clientRect.right - 155, 6, 24,24);
  m_CurTimeEdit.MoveWindow(clientRect.right - 130, 6, 55, 24);
  GetDlgButton(this, IDC_NEXTFRAMEBUT)->MoveWindow(clientRect.right - 75, 6, 24,24);
  GetDlgButton(this, IDC_NEXTKEYFRAMEBUT)->MoveWindow(clientRect.right - 50, 6, 24,24);
  GetDlgButton(this, IDC_PLAYBUT)->MoveWindow(clientRect.right - 25, 6, 24,24);
  
  RECT rect;
  m_SingleLineOutputEdit.GetWindowRect(&rect);
  ScreenToClient(&rect);
  rect.right = clientRect.right - 5;

  m_SingleLineOutputEdit.SetWindowPos(NULL, 0, 0, rect.right - rect.left, rect.bottom - rect.top, SWP_NOMOVE | SWP_NOZORDER);

  //   m_PanViewsBut.MoveWindow(6, 6, PanButRect.right, 54);
}


int CBottomDlg::GetHeight()
{
  RECT  ClientRect;
  if (!::IsWindow(m_hWnd))
    return 0;
  
  GetClientRect(&ClientRect);
  return ClientRect.bottom;
}


BOOL CBottomDlg::OnCommand(WPARAM wParam, LPARAM lParam) 
{
  UINT  CmdID, Msg;
  HWND  hWnd;
  CWnd  *Parent;
  
  Parent = GetParentOwner();
  CmdID = LOWORD(wParam);
  Msg = HIWORD(wParam);
  hWnd = (HWND)lParam;
  
  if (Msg == BN_CLICKED)
  {
    switch(CmdID)
    {
    case IDC_ANIMATEBUT:
      KAnimToggleAnimate();
      break;
      /*      case IDC_NEXTFRAMEBUT:
      KControlNextFrame();
      break;
      case IDC_PREVFRAMEBUT:
      KControlPrevFrame();
      break;*/
    }
  }
  
  return CDialog::OnCommand(wParam, lParam);
}

void CBottomDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  if (nSBCode != SB_THUMBPOSITION && nSBCode != SB_THUMBTRACK)
    nPos = m_TimeScroll.GetScrollPos();
  if (nSBCode == SB_LINELEFT)
    nPos --;
  if (nSBCode == SB_LINERIGHT)
    nPos ++;
  if (nSBCode == SB_PAGELEFT)
    nPos -= 10;
  if (nSBCode == SB_PAGERIGHT)
    nPos += 10;
  
  g_Scene->setTime(nPos*120);
  
  {
    MStr  Str;
    Str.Format("%i", g_Scene->getTime()/120);
    m_CurTimeEdit.SetWindowText((LPCTSTR)Str);
  }
  
  GetOwner()->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  GetOwner()->SendMessage(MM_UPDATECHANNELBAR, 0, 0);
  
  CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

BOOL CBottomDlg::PreTranslateMessage(MSG* pMsg) 
{
  if (pMsg->message == WM_KEYDOWN || pMsg->message == WM_KEYUP)
  {
    LONG  WndStyle;
    
    WndStyle = GetWindowLong(pMsg->hwnd, GWL_STYLE);
    if (WndStyle & ES_AUTOHSCROLL)
    {
      // we have an edit box
      if (pMsg->message == WM_KEYDOWN)
      {
        if (pMsg->wParam == VK_ESCAPE || pMsg->wParam == VK_RETURN)
        {
          if (pMsg->wParam == VK_RETURN)
          {
            if (pMsg->hwnd == GetDlgItem(IDC_CURTIMEEDIT)->m_hWnd)
            {
              // Update the current time
              CString  Str;
              float    Time;
              
              GetDlgItem(IDC_CURTIMEEDIT)->GetWindowText(Str);
              Time = (float)atof((LPCTSTR)Str);
              g_Scene->setTime((int)(Time*120));
              UpdateScroller();
            }
          }
          
          GetParentOwner()->SetFocus();
          return 1;
        }
      }
    }
    else
      return GetParentOwner()->PostMessage(pMsg->message, pMsg->wParam, pMsg->lParam);
  }
  
  // Call CWnd::PreTranslate message so we do not get the special dialog message handling
  return CWnd::PreTranslateMessage(pMsg);
}


CoordinateListener::CoordinateListener(CEdit *edit) 
  : coordEdit(edit)
{
}

// MListener methods
void CoordinateListener::onListen() {
  MStr text;
  MVector3 coords;
  if (MUIManager::getWorldCoordinates(coords)) {
    text += coords.convertToString("X:%.2f Y:%.2f Z:%.2f   ");
  }
  if (MUIManager::getDiffCoordinates(coords)) {
    text += coords.convertToString("dx:%.2f dy:%.2f dz:%.2f");
  }
  coordEdit->SetWindowText(text.c_str());
}


int CBottomDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
  if (CDialog::OnCreate(lpCreateStruct) == -1)
    return -1;
  
  m_TimeScroll.Create(NULL, "TimeScroller", WS_CHILD | WS_VISIBLE, CRect(0,0,10,10), this, 10);

  return 0;
}


void CBottomDlg::UpdateScroller() {
  m_TimeScroll.ClearAllKeyLists();
  
  MBaseObjectPtr SelObj;
  MTreeObjectNodePtr SelObjNode;
  MTransformObjectPtr XForm;
  
  g_Scene->getSelectedObjectList()->beginIteration();
  
  while ((SelObj = g_Scene->getSelectedObjectList()->getNext()) != NULL) {
    SelObjNode = g_Scene->getObjectList()->findObject(SelObj);
    
    XForm = g_Scene->getTransform(SelObjNode);
    
    if (XForm != NULL) {
      m_TimeScroll.addKeyableValue(AZTEC_CAST(MKeyableValue, XForm->getTranslateKey()));
      m_TimeScroll.addKeyableValue(AZTEC_CAST(MKeyableValue, XForm->getRotateKey()));
      m_TimeScroll.addKeyableValue(AZTEC_CAST(MKeyableValue, XForm->getScaleKey()));
    }
  }
  
  g_Scene->getSelectedObjectList()->endIteration();

  m_TimeScroll.SetScrollPos(g_Scene->getTime()/120);
  m_TimeScroll.InvalidateRect(NULL);
  
  {
    MStr  Str;
    Str.Format("%i", g_Scene->getTime()/120);
    m_CurTimeEdit.SetWindowText((LPCTSTR)Str);
  }
  
  //   m_TimeScroll.OnPaint();
  //   ::SendMessage(m_TimeScroll.m_hWnd, WM_PAINT, 0,0);
}

LRESULT CBottomDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
  if (message == TS_TIMESCROLL_BEFORECHANGE)
  {
    Aztec::getSystemManager()->getUndoManager()->beginUndo("Time Change");
  }
  if (message == TS_TIMESCROLL_AFTERCHANGE)
  {
    Aztec::getSystemManager()->getUndoManager()->endUndo();
  }
  
  if (message == WM_KEYDOWN)
  {
    Sleep(1);
  }
  
  return CDialog::WindowProc(message, wParam, lParam);
}

void CBottomDlg::OnChangeStartedit() 
{
  CString strValue;
  int value;

  m_StartEdit.GetWindowText(strValue);

  value = atoi((LPCTSTR)strValue);

  if (value != m_TimeScroll.GetScrollMin()) {
    g_Scene->setStartTime( g_Scene->frameToTick( value ) );
  }

  GetOwner()->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  GetOwner()->SendMessage(MM_UPDATECHANNELBAR, 0, 0);

}

void CBottomDlg::OnChangeEndedit() 
{
  CString strValue;
  int value;

  m_EndEdit.GetWindowText(strValue);

  value = atoi((LPCTSTR)strValue);

  if (value != m_TimeScroll.GetScrollMax()) {
    g_Scene->setEndTime( g_Scene->frameToTick( value ) );
  }

  GetOwner()->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  GetOwner()->SendMessage(MM_UPDATECHANNELBAR, 0, 0);
  
}


void CBottomDlg::OnDestroy() {
  MUIManager::removeListener(MUIManager::COORDINATE_FEEDBACK_LISTENER, coordinateListener);

  CDialog::OnDestroy();
}
