// ClrCgfPg.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "AztecMain.h"
#include "ClrCfgPg.h"

#include "Colors.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CColorConfigPage property page

IMPLEMENT_DYNCREATE(CColorConfigPage, CPropertyPage)

CColorConfigPage::CColorConfigPage() : CPropertyPage(CColorConfigPage::IDD)
{
	//{{AFX_DATA_INIT(CColorConfigPage)
	//}}AFX_DATA_INIT

   m_OldColors = NULL;
   m_NewColors = NULL;
}

CColorConfigPage::~CColorConfigPage()
{
}

void CColorConfigPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CColorConfigPage)
	DDX_Control(pDX, IDC_OLDCOLORBUT, m_OldColorBut);
	DDX_Control(pDX, IDC_NEWCOLORBUT, m_NewColorBut);
	DDX_Control(pDX, IDC_COLORITEMLIST, m_ColorItemList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CColorConfigPage, CPropertyPage)
	//{{AFX_MSG_MAP(CColorConfigPage)
	ON_LBN_SELCHANGE(IDC_COLORITEMLIST, OnSelchangeColoritemlist)
	ON_BN_CLICKED(IDC_CHOOSECOLORBUT, OnChoosecolorbut)
	ON_BN_CLICKED(IDC_RESETCOLORSTODEFAULTBUT, OnResetcolorstodefaultbut)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColorConfigPage message handlers

BOOL CColorConfigPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
   m_ColorItemList.SetCurSel(0);

        for (int i=0;i<NUM_COLORS;i++)
   {
      m_ColorItemList.AddString(COLORNAMES[i]);
   }

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CColorConfigPage::UpdateColorButtons()
{
   m_OldColorBut.SetColor(m_OldColors[m_ColorItemList.GetCurSel()]);
   m_NewColorBut.SetColor(m_NewColors[m_ColorItemList.GetCurSel()]);
}

void CColorConfigPage::SetOldNewColors(COLORREF *Old, COLORREF *New)
{
   m_OldColors = Old;
   m_NewColors = New;
   
}

void CColorConfigPage::OnSelchangeColoritemlist() 
{
   UpdateColorButtons();	
}

void CColorConfigPage::OnSelchangePalettelist() 
{
//   m_NewColors[m_ColorItemList.GetCurSel()] = m_PaletteList.GetCurSel();	
   UpdateColorButtons();
}

void CColorConfigPage::OnChoosecolorbut() 
{
   CColorDialog   ClrDlg;

   if (!ClrDlg.DoModal())
      return;

   m_NewColors[m_ColorItemList.GetCurSel()] = ClrDlg.GetColor();
   UpdateColorButtons();
}

void CColorConfigPage::OnResetcolorstodefaultbut() 
{
   m_NewColors[0] = 0x666666,
   m_NewColors[1]	= 0x4C4C4C,
   m_NewColors[2] = WHITE,
   m_NewColors[3] = 0x20FF20,
   m_NewColors[4] = 0x20E020,
   m_NewColors[5] = 0x20E6E6,
   m_NewColors[6]	= YELLOW,
   m_NewColors[7] = ORANGE,
   m_NewColors[8] = AQUA,
   m_NewColors[9] = RED,
   m_NewColors[10] = GREEN,
   m_NewColors[11] = BLUE;
	
   UpdateColorButtons();
}
