#include <AztecMainPCH.h>
#include "MToolTipWnd.h"

bool     g_ClassRegistered = false;
char     *g_ClassName = "MToolTipWnd";

// global isntance of the one and single tool tip.
MToolTipWnd       g_ToolTipWnd;

// Foward declarations of functions included in this code module:
ATOM				RegisterToolTipClass(HINSTANCE hInstance);
LRESULT CALLBACK	ToolTipWndProc(HWND, UINT, WPARAM, LPARAM);


MToolTipWnd::MToolTipWnd() {
  m_TimeOut = 0;
  m_TimerID = 0;
  
  m_hWnd = NULL;
  m_hParentWnd = NULL;
  m_hMouseOverWnd = NULL;
  m_ThreadID = 0;
  m_hThread = 0;
}

MToolTipWnd::~MToolTipWnd() {
  //   DestroyToolWnd();
}


int MToolTipWnd::CreateToolTip(HWND ParentWnd, int X, int Y, int ShowTime, int Timeout, const MStr &Message) {

  // Destroy any previous tool tip window
  DestroyToolWnd();
  
  m_hParentWnd = ParentWnd;
  m_Text = Message;
  CreateToolWnd(X, Y);
  
  // Create the timer
  
  ::SetTimer(m_hWnd, 1400, ShowTime, NULL);
  ::SetTimer(m_hWnd, 1500, Timeout+ShowTime, NULL);
  
  return 1;
}

int MToolTipWnd::CreateToolWnd(int X, int Y) {
  HINSTANCE      hInstance;
  
  hInstance = AfxGetApp()->m_hInstance;
  
  if (!hInstance) {
    return NULL;
  }

  // register the window class necessary
  if (!g_ClassRegistered) {
    RegisterToolTipClass(hInstance);
    g_ClassRegistered = true;
  }
  
  // do not create the tool tip if the window
  // we are meant to be under creating isn't
  // where the mouse is.
  if (m_hParentWnd != m_hMouseOverWnd) {
    return 0;
  }

  // create the window.
  m_hWnd = CreateWindow(g_ClassName, (LPCTSTR)m_Text, WS_EX_TOOLWINDOW | WS_EX_TOPMOST | WS_POPUP | WS_DISABLED,
    CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, m_hParentWnd, NULL, hInstance, NULL);
  
  // put the tool tip in a nice location
  RECT     Rect;
  POINT    Pos;
  
  Pos.x = X;
  Pos.y = Y;
  
  ClientToScreen(m_hParentWnd, &Pos);
  
  Rect.left = X;
  Rect.top = Y;
  Rect.right = X + 100;
  Rect.bottom = Y + 20;
  
  // size the window to be a nice size
  {
    HDC      hDC;
    SIZE     Size;
    
    hDC = ::GetDC(m_hWnd);
    ::SelectObject(hDC, ::GetStockObject(DEFAULT_GUI_FONT));
    
    GetTextExtentPoint32(hDC, (LPCTSTR)m_Text, m_Text.GetLength(), &Size);
    
    ::ReleaseDC(m_hWnd, hDC);
    ::MoveWindow(m_hWnd, Pos.x, Pos.y, Size.cx + 2, Size.cy + 2, TRUE);
  }
  
  return 1;
}

int MToolTipWnd::DestroyToolWnd() {
  if (m_hWnd != NULL) {
    ::DestroyWindow(m_hWnd);
  }
  
  m_hWnd = NULL;
  m_hParentWnd = NULL;
  
  return 1;
}

void MToolTipWnd::DestroyToolTip() {
  DestroyToolWnd();
}


void MToolTipWnd::SetMouseOverWnd(HWND MouseOverWnd) {
  m_hMouseOverWnd = MouseOverWnd;
}

HWND MToolTipWnd::GetMouseOverWnd() {
  return m_hMouseOverWnd;
}

ATOM RegisterToolTipClass(HINSTANCE hInstance) {
  WNDCLASSEX wcex;
  
  wcex.cbSize = sizeof(WNDCLASSEX); 
  
  wcex.style			= CS_HREDRAW | CS_VREDRAW;
  wcex.lpfnWndProc	= (WNDPROC)ToolTipWndProc;
  wcex.cbClsExtra		= 0;
  wcex.cbWndExtra		= 0;
  wcex.hInstance		= hInstance;
  wcex.hIcon			= NULL;
  wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
  wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
  wcex.lpszMenuName	= NULL;
  wcex.lpszClassName	= g_ClassName;
  wcex.hIconSm		= NULL;
  
  return RegisterClassEx(&wcex);
}

LRESULT CALLBACK ToolTipWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
  int         wmId, wmEvent;
  PAINTSTRUCT ps;
  HDC         hdc;
  char        Text[1024];
  int         TextLen;
  
  switch (message) {
		case WM_COMMAND:
      wmId    = LOWORD(wParam); 
      wmEvent = HIWORD(wParam); 
      // Parse the menu selections:
      switch (wmId) {
      default:
        return DefWindowProc(hWnd, message, wParam, lParam);
      }
      break;
      case WM_PAINT:
        hdc = BeginPaint(hWnd, &ps);

        RECT rt;
        GetClientRect(hWnd, &rt);
        ::FillRect(hdc, &rt, (HBRUSH)::GetStockObject(BLACK_BRUSH));
        
        rt.top += 1;
        rt.left += 1;
        rt.right -= 1;
        rt.bottom -= 1;
        TextLen = GetWindowText(hWnd, Text, 1024);
        ::SelectObject(hdc, ::GetStockObject(DEFAULT_GUI_FONT));
        DrawText(hdc, Text, TextLen, &rt, DT_CENTER);

        EndPaint(hWnd, &ps);
        break;
      case WM_SIZE:
        break;
      case WM_TIMER:
        if (wParam == 1400) {
          KillTimer(hWnd, 1400);
          ::ShowWindow(hWnd, SW_SHOWNOACTIVATE);
        } else if (wParam == 1500) {
          KillTimer(hWnd, 1500);
          DestroyWindow(hWnd);
        }
        break;
      default:
        return DefWindowProc(hWnd, message, wParam, lParam);
  }
  return 0;
}

