#include <AztecMainPCH.h>

#include "resource.h"

#include "MenuItem.h"
#include "Keyboard.h"
#include "MdlConst.h"

#include "DlgGlobs.h"   // Global dialog variables.
#include "MdlGlobs.h"
#include "MdlMsgs.h"

#include "KeyFuncAnim.h"
#include "KeyFuncMain.h"

#include "UndoGeneral.h"

#include "limits.h"

#include <animation/MIKControllerCCD.h>

#include <tools/MIKBoneTool.h>

//----------------------------------------------------------------------------------------
#define GetDlgButton(D,R)     ((CButton*)D.GetDlgItem(R))

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


using namespace std;

int ikBoneTool() {
  g_ToolMan.PushTool(new MIKBoneTool());
  g_MainDlg->PostMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  return 1;
}

void InitAnimActionList(MActionListType *AL)
{
  g_SysMan->logOutput("Initialising Animation Action List");
  
  // General
  AL->Add("KAnimToggleAnimate", "Animate Mode Toggle", "Animate", KAnimToggleAnimate);
  AL->Add("KAnimSetTranslateKey", "Set Translate Key","Animate",KAnimSetTranslateKey);
  AL->Add("KAnimSetRotateKey", "Set Rotate Key","Animate",KAnimSetRotateKey);
  AL->Add("KAnimSetScaleKey", "Set Scale Key","Animate",KAnimSetScaleKey);
  
  // Time Segment functions.
  AL->Add("KAnimCreateTimeSegment", "Create a Time Segment", "Animate", KAnimCreateTimeSegment);
  AL->Add("KAnimAddObjectToTimeSegment", "Add Objects to Time Segments", "Animate", KAnimAddObjectToTimeSegment, g_MainDlg, ID_ANIMATION_ADDOBJECTSTOTIMESEGMENTS);
  AL->Add("KAnimRemoveObjectFromTimeSegment", "Remove Objects From Time Segments", "Animate", KAnimRemoveObjectFromTimeSegment, g_MainDlg, ID_ANIMATION_REMOVEOBJECTSFROMTIMESEGMENTS);
  AL->Add("KAnimZoomToTimeSegment", "Zoom to current Time Segment", "Animate", KAnimZoomToTimeSegment, g_MainDlg, ID_ANIMATION_ZOOMTOTIMESEGMENT);

  // Constaint functions
  AL->Add("KAnimAddConstraintAim", "Add Aim Constraint", "Animate", KAnimAddConstraintAim, g_MainDlg, ID_ANIMATION_ADDAIMCONSTRAINT);

  AL->Add("ikBoneTool", "ikBoneTool", "Animate", ikBoneTool, g_MainDlg, ID_ANIMATION_IKBONETOOL);

}

#include "MLookAt.h"

int KAnimToggleAnimate() {
  g_SysMan->getSettings()->m_Animate = !g_SysMan->getSettings()->m_Animate;
  
  if (g_SysMan->getSettings()->m_Animate) {
    GetDlgButton(g_MainDlg->m_BottomToolDlg, IDC_ANIMATEBUT)->SetCheck(1);
  } else {
    GetDlgButton(g_MainDlg->m_BottomToolDlg, IDC_ANIMATEBUT)->SetCheck(0);
  }
  
  return 1;
}

int KAnimHelperSetKeyOnSelected(DWORD KeyChannel)
{
  MBaseObjectPtr Obj;
  MNamedObjectPtr namedObj;
  MSceneObjectPtr SceneObj;
  MTransformObjectPtr XFormObj;
  int               Count = 0;
  
  g_Scene->getObjectList()->beginIteration();
  
  while ((Obj = g_Scene->getObjectList()->getNext()) != NULL) {
    if (!Obj->isFlagged(OBJECTFLAG_SELECTED))
      continue;
    
    namedObj = AZTEC_CAST(MNamedObject, Obj);
    
    if (namedObj == NULL) {
      continue;
    }
    
    SceneObj = AZTEC_CAST(MSceneObject, Obj);
    
    if (SceneObj == NULL) {
      g_SysMan->logOutput("Warning: Could not set key on Object '%s'", (LPCTSTR)namedObj->getName());
      continue;
    }
    
    XFormObj = SceneObj->getTransformObject();
    
    if (XFormObj == NULL) {
      g_SysMan->logOutput("Warning: Could not get the TransformObject for Object '%s'", (LPCTSTR)namedObj->getName());
      continue;
    }
    
    XFormObj->updateKey(g_Scene->getTime(), KeyChannel, true);
    Count++;
  }
  g_Scene->getObjectList()->endIteration();
  
  return Count;
}


int KAnimSetTranslateKey()
{
  KAnimHelperSetKeyOnSelected(TRANSFORM_CHAN_TRANSLATE);
  
  g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KAnimSetRotateKey()
{
  KAnimHelperSetKeyOnSelected(TRANSFORM_CHAN_ROTATE);
  
  g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KAnimSetScaleKey()
{
  KAnimHelperSetKeyOnSelected(TRANSFORM_CHAN_SCALE);
  
  g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KAnimCreateTimeSegment() {
  int result;

  MTimeSegmentPtr timeSeg = new MTimeSegment();
  timeSeg->setName( "TimeSegment" );
  timeSeg->setRange( g_Scene->getStartTime(), g_Scene->getEndTime() );

  result = (g_Scene->addObject(timeSeg) != NULL);

  g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);

  return 1;
}

int doActionToTimeSegment(bool remove) {
  MBaseObjectTreePtr objList = g_Scene->getObjectList();
  MBaseObjectPtr obj; 
  vector<MTimeSegmentPtr> segs;
  vector<MNamedObjectPtr> objs;

  objList->beginIteration();

  while ((obj = objList->getNext()) != NULL) {
    if (!obj->isFlagged(OBJECTFLAG_SELECTED)) {
      continue;
    }

    MTimeSegmentPtr timeSeg = AZTEC_CAST(MTimeSegment, obj);
    MNamedObjectPtr namedObj = AZTEC_CAST(MNamedObject, obj);

    // if we have a timesegment, keep track of it,
    // otherwise we have an object to add.
    if (timeSeg != NULL) {
      segs.push_back(timeSeg);
    } else if (namedObj != NULL) {
      objs.push_back(namedObj);
    }
  }
  objList->endIteration();

  // if we have no segments or objects, we can't do anything.
  if (segs.size() == 0 || objs.size() == 0) {
    g_SysMan->logOutput("Error: At least 1 Time Segment and at least 1 Object need to be selected");
    return 0;
  }

  // add all the objects to the time segments.
  vector<MTimeSegmentPtr>::iterator segsIter;
  vector<MNamedObjectPtr>::iterator objsIter;

  for (segsIter = segs.begin(); segsIter != segs.end(); ++segsIter) {
    for (objsIter = objs.begin(); objsIter != objs.end(); ++objsIter) {
      if (remove) {
        (*segsIter)->removeObject(*objsIter);
      } else {
        (*segsIter)->addObject(*objsIter);
      }
    }
  }

  return 1;
}


int KAnimAddObjectToTimeSegment() {
  int result = doActionToTimeSegment(false);

  g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);

  return result;
}

int KAnimRemoveObjectFromTimeSegment() {
  int result = doActionToTimeSegment(true);

  g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);

  return result;
}

int KAnimZoomToTimeSegment() {
  MBaseObjectTreePtr objList = g_Scene->getObjectList();
  MBaseObjectPtr obj;

  int min = INT_MAX, max = INT_MIN;

  objList->beginIteration();

  while ((obj = objList->getNext()) != NULL) {
    if (!obj->isFlagged(OBJECTFLAG_SELECTED)) {
      continue;
    }

    MTimeSegmentPtr timeSeg = AZTEC_CAST(MTimeSegment, obj);

    // if we have a timesegment, keep track of it,
    // otherwise we have an object to add.
    if (timeSeg != NULL) {
      if (timeSeg->getStart() < min) {
        min = timeSeg->getStart();
      }
      if (timeSeg->getEnd() > max) {
        max = timeSeg->getEnd();
      }
    }
  }
  objList->endIteration();

  if (min != INT_MAX && max != INT_MIN) {
    g_Scene->setTimeRange(min, max);

    g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
    g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);

    return 1;
  }

  return 0;
}

int KAnimAddConstraintAim() {
  // do a bit of hackey goodness.
  MLookAtPtr look = new MLookAt;

  g_Scene->addObject(look);

  MBaseObjectPtr Obj;
  MSceneObjectPtr SceneObj;

  MSceneObjectPtr srcObj, targObj;

  g_Scene->getSelectedObjectList()->beginIteration();
  
  while ((Obj = g_Scene->getSelectedObjectList()->getNext()) != NULL) {
    SceneObj = AZTEC_CAST(MSceneObject, Obj);
    
    if (SceneObj == NULL) {
      continue;
    }

    // if we don't have a source object, it must be this one
    if (srcObj == NULL) {
      srcObj = SceneObj;
      look->setSource(SceneObj);
      continue;
    }

    // if we don't have a target object, it must be this one
    look->setTarget(SceneObj);
    targObj = SceneObj;
    break;
  }
  g_Scene->getSelectedObjectList()->endIteration();

  if (srcObj == NULL) {
    g_SysMan->logOutput("Could not add the Aim Constraint, there were no objects selected that we could aim.");
    return 0;
  }
  if (targObj == NULL) {
    g_SysMan->logOutput("Could not add the Aim Constraint, there were no objects selected to aim at.");
    return 0;
  }

  // No we add the controller in.
  srcObj->getTransformObject()->findParameter("Rot")->setInputParameter(look->findParameter("rot"));

  g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);

  return 1;
}

