function showParams(obj) {
  for (x in obj)
    print(x + ": " + obj[x]);
}

function deg2rad(t) {
  return t * Math.PI / 180.0;
}

function spinObj(obj) {
  var v1 = new AztecVector3(0, 0, 0);
  for (x=0.0;x<=2.0*Math.PI;x+=0.2) {
    v1.x = 20.0 * Math.cos(x);
    v1.y = 20.0 * Math.sin(x);
	obj.Translate = v1;
  }
}

function rotObj(obj) {
  var mat = new AztecMatrix4;
  var vec1 = new AztecVector3(20, 0, 0);
  var vec2 = new AztecVector3;
  for (x=0.0;x<=2.0*Math.PI;x+=0.2) {
    mat.rotZ(x);
    mat.transform(vec1, vec2);
    obj.Translate = vec2;
    Scene.redraw();
  }
}

function makeSpheres() {
  var vec1 = new AztecVector3(0.2, 0.2, 0.2);
  var vec2 = new AztecVector3;
  t = 30.0;

  for (x=0.0;x<=2.0*Math.PI;x+=0.05) {
    var obj = Scene.createObject("MPrimitiveSphere");

	obj.Scale = vec1;

    r = 5.0 * Math.sin(x);
    vec2.x = r * Math.cos(3.0 * x);
    vec2.y = r * Math.sin(3.0 * x);
    vec2.z = t * (0.5 * x / Math.PI);
	obj.Translate = vec2;
  }
}

// Create several spheres and glue them together
function buildCSG() {
  var obj1, obj2, csgobj;

  obj1 = Scene.createObject("MPrimitiveSphere");
  obj2 = Scene.createObject("MPrimitiveSphere");
  txvec = new AztecVector3(7.5, 0, 0);
  obj2.Translate = txvec; // Assume default radius is 10.0

  csgobj = Scene.createObject("MPrimitiveCSG");
  csgobj.shape.Mesh1 = obj1.Name;
  csgobj.shape.Mesh2 = obj2.Name;
  csgobj.shape.csgOp = "Union";

  // Hide the two original spheres
  Scene.selectNone();
  Scene.selectObject(obj1);
  Scene.KControlHideSelected();

  Scene.selectNone();
  Scene.selectObject(obj2);
  Scene.KControlHideSelected();

  // Select the CSG object
  Scene.selectNone();
  Scene.selectObject(csgobj);
}

function makeDisc(numT) {
  meshObj = Scene.createMesh();
  mesh = meshObj.getMesh();
  v = new AztecVector3;
  mesh.addVertex(v);
  i = 0;
  delta = 2.0 * Math.PI / numT;
  x = 0.0;
  for (j=0;j<numT;j+=1,x+=delta) {
    v.x = 10.0 * Math.cos(x);
    v.y = 10.0 * Math.sin(x);
    mesh.addVertex(v);
    i++;
    if (i > 1) {
      mesh.addTriangle(0, i-1, i);
    }
  }
  mesh.addTriangle(0, i, 1);
}

function makeVariety() {
  light = Scene.createObject('light', "myLight");
  var ltx = new AztecVector3(20, 50, 70);
  light.Tsl = ltx;
  var lcol = new AztecVector3(1, 0, 0.5);
  light.shape.Col = lcol;

  cube = Scene.createObject('cube', 'testCube');
  cube.shape.WidthDiv = 5;
  cube.shape.HeightDiv = 5;
  cube.shape.DepthDiv = 5;

  cube.shape.Depth = 100;
}
