#include <AztecMainPCH.h>
#include <MGLRotateTool.h>

// AztecMain includes
#include <MDLGlobs.h>

// standard includes
#include <math.h>

//---------------------
//  MGLRotateToolType
//---------------------
MGLRotateToolType::MGLRotateToolType()
{
  setName("KToolRotate");
  m_RequiresSel = true;
  m_RotAng = 0;
}

int MGLRotateToolType::DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View)
{
  // Get the current viewport and cast it to a gl wnd.
  COpenGLWnd     *GLWnd;
  bool           DrawManips, PopMatrix;
  
  
  GLWnd = AZTEC_CAST(COpenGLWnd, View);
  
  if (GLWnd == NULL)
    return 0;
  
  if (!m_Dragging) {
    m_PivotPoint = g_Scene->getSelectionCentre();
    getAxisMatrix(GLWnd);
  }
  
  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_DEPTH_TEST);
  
  
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  
  // Perform the viewport transformation
  
  GLWnd->DoViewportTransform();
  glMatrixMode(GL_MODELVIEW);
  
  PopMatrix = true;
  glPushMatrix();
  
  float ScaleFact = GLWnd->GetScaleFactor(m_PivotPoint) * 0.75;
  glTranslatef(m_PivotPoint.x, m_PivotPoint.y, m_PivotPoint.z);
  glMultMatrixf((float*)m_AxisTransform.m);
  glScalef(ScaleFact, ScaleFact, ScaleFact);
  
  if (RequiresSelection()) {
    DrawManips = g_Scene->anythingSelected();
  } else {
    DrawManips = true;
  }
  
  if (DrawManips) {
    GLWnd->DrawRotateIcon(g_IconSize,0.5f,3, Select);
    
    if (m_Dragging) {
      float       Rot;
      MVector3    CurPos, Res;
      
      glPopMatrix();
      PopMatrix = false;
      
      glTranslatef(m_Orig.x, m_Orig.y, m_Orig.z);
      glScalef(ScaleFact, ScaleFact, ScaleFact);
      glScalef(g_IconSize, g_IconSize, g_IconSize);
      
      glColor4f(0,1,1,0.1f);
      
      // have to draw a filled arc going from vecb to veca. Which lasts m_RotAng degrees
      
      if (m_RotAng < 0)
        Rot = -m_RotAng;
      else 
        Rot = m_RotAng;
      
      // draw it using a fan
      glBegin(GL_TRIANGLE_FAN);
      
      glVertex3f(0,0,0);
      glColor4f(0,1,1,0.3f);
      
      CurPos = m_VecB;
      while (Rot > 0)
      {
        glVertex3fv((float*)&CurPos);
        rotateWithVector(CurPos, m_VecC, (float)(-10.0*3.14159 / 180.0), Res);
        CurPos = Res;
        Rot -= 10;
      }
      
      glVertex3fv((float*)&m_VecA);
      glEnd();
    }
  }
  
  if (PopMatrix) {
    glPopMatrix();
  }
  
  glPopMatrix();
  
  glPopAttrib();
  
  return 1;
}

int MGLRotateToolType::onMouseDown(int X, int Y, const MShiftState &Shift)
{
  MVector3    Orig, Dir, ViewNorm;
  MMatrix4    XFormMat;
  
  GetPlaneParams(Orig, Dir, ViewNorm ,XFormMat);
  m_ViewNorm = ViewNorm;
  
  // Override the direction stuff to suit the rotation gizmo's needs
  if (m_PickedManip == 1) {
    Dir.set(1,0,0);
  } else if (m_PickedManip == 2) {
    Dir.set(0,1,0);
  } else if (m_PickedManip == 3) {
    Dir.set(0,0,1);
  } else if (m_PickedManip == 4) {
    Dir = ViewNorm;
  }
  
  if (m_PickedManip != 4) {
    Dir = m_AxisTransform * Dir;
  }

  Dir.normalize();
  
  m_Constraint.setConstraint(MPlane(Orig, Dir));

  // do this work after we have set up our constrain plane 
  // so it works properly
  MXYZToolType::onMouseDown(X, Y, Shift);

  return TOOLRESULT_DRAWALL;
}

int MGLRotateToolType::onMouseUp(int X, int Y, const MShiftState &Shift)
{
  MXYZToolType::onMouseUp(X, Y, Shift);
  
  UpdateKeys("Rotate", TRANSFORM_CHAN_ROTATE);
  
  return TOOLRESULT_DRAWALL;
}

int MGLRotateToolType::onMouseMove(int X, int Y, const MShiftState &Shift)
{
  MXYZToolType::onMouseMove(X, Y, Shift);
  
  if (!m_Dragging) {
    return TOOLRESULT_DRAWNONE;
  }
  
  MVector3    OfsVec, MoveVec;
  float       RotateAng;
  
  OfsVec = m_CurVec;
  OfsVec -= m_DownVec;
  
  // Go through the currently selected objects, and move their components.
  MBaseObjectPtr BaseObj;
  MSceneObjectPtr Obj;
  g_Scene->getObjectList()->beginIteration();
  while (( BaseObj = g_Scene->getObjectList()->getNext() ) != NULL )
  {
    Obj = AZTEC_CAST(MSceneObject, BaseObj);
    if (Obj == NULL) {
      continue;
    }
    
    MTreeObjectNodePtr ObjNode;
    
    ObjNode = g_Scene->getObjectList()->getCurrentNode();
    
    {
      MVector3    A,B, C, Cross;
      float       dot, A1;
      
      MVector3 ObjWorld;
      ObjWorld = g_Scene->getWorldTransformTranslate(g_Scene->getObjectList()->findObject(g_Scene->getSelectedObjectList()->getTail()));
      
      //         A = m_CurVec - ObjWorld;
      //         B = m_DownVec - ObjWorld;
      A = m_CurVec - m_PivotPoint;
      B = m_DownVec - m_PivotPoint;
      
      A.normalize();
      B.normalize();
      
      dot = A*B;
      if (dot < -1)
        dot = -1;
      if (dot > 1)
        dot = 1;
      A1 = (float)(acos(dot)* 180 / 3.14159); 
      
      Cross = A/B;
      Cross.normalize();
      dot = Cross * m_Constraint.getConstraintNormal();
      if (dot > 0)
        A1 = -A1;
      
      {
        //            m_Orig = ObjWorld + m_PivotPoint;
        m_Orig = m_PivotPoint;
        m_VecA = A;
        m_VecB = B;
        m_VecC = Cross;  
        m_VecC.normalize();
        m_VecD = m_Constraint.getConstraintNormal();
        m_RotAng = A1;
      }
      
      
      RotateAng = A1;
    }
    
    
    MComponentisedObjectPtr compObj = Obj->getComponentObject();
    if (compObj != NULL && compObj->isInComponentMode()) {
      MEditableComponentisedObjectPtr editableCompObj = Obj->getEditableComponentObject();
      if (editableCompObj != NULL && editableCompObj->isInComponentMode()) {

        editableCompObj->restoreComponentPositions(
          editableCompObj->getComponentMode(),
          MComponentisedObject::COMPONENT_SELECTED);

        MMatrix4 objToWorld;
        MMatrix4 worldToObj;
        g_Scene->getWorldTransformMatrix(ObjNode, objToWorld);
        worldToObj = objToWorld;
        worldToObj.inverse();

        MMatrix4 transform;
        transform.identity();

        MVector3 localPivot = worldToObj * m_PivotPoint;

        worldToObj.m[3][0] = 0;
        worldToObj.m[3][1] = 0;
        worldToObj.m[3][2] = 0;

        transform.m[3][0] -= localPivot.x;
        transform.m[3][1] -= localPivot.y;
        transform.m[3][2] -= localPivot.z;

        transform.rotateWithVector(worldToObj * m_Constraint.getConstraintNormal(), RotateAng*3.1415926535897932384626/180.0);

        transform.m[3][0] += localPivot.x;
        transform.m[3][1] += localPivot.y;
        transform.m[3][2] += localPivot.z;

        editableCompObj->transformComponents(
          editableCompObj->getComponentMode(),
          transform,
          MComponentisedObject::COMPONENT_SELECTED,
          false);
      }
    } else if (Obj->isFlagged(OBJECTFLAG_SELECTED)) {
      MTransformObjectPtr XForm;
      
      XForm = Obj->getTransformObject();
      
      if (XForm != NULL)
      {
        MVector3 Vec, axis;
        MMatrix4 mat;
        MVector3 x,y,z,nx,ny,nz;

        XForm->fetchValues();
        Vec = XForm->getRotateVector(g_Scene->getTime());
        Vec *= (float)(M_PI / 180.0);
        mat.convertFromEuler(Vec);

        x.set(mat.m[0][0], mat.m[0][1], mat.m[0][2]);
        y.set(mat.m[1][0], mat.m[1][1], mat.m[1][2]);
        z.set(mat.m[2][0], mat.m[2][1], mat.m[2][2]);

        axis = m_Constraint.getConstraintNormal();
        axis.normalize();
        rotateWithVector(x, axis, RotateAng*3.1415926535897932384626/ 180.0, nx);
        rotateWithVector(y, axis, RotateAng*3.1415926535897932384626/ 180.0, ny);
        rotateWithVector(z, axis, RotateAng*3.1415926535897932384626/ 180.0, nz);

        mat.m[0][0] = nx.x; mat.m[0][1] = nx.y; mat.m[0][2] = nx.z;
        mat.m[1][0] = ny.x; mat.m[1][1] = ny.y; mat.m[1][2] = ny.z;
        mat.m[2][0] = nz.x; mat.m[2][1] = nz.y; mat.m[2][2] = nz.z;

        mat.convertToEuler(Vec);
        Vec *= (float)(180.0 / M_PI);
        XForm->setRotateVector(Vec);
        XForm->setParamByName("Rot", Vec.convertToString(), false);

      }
    }         
   }
   g_Scene->getObjectList()->endIteration();
   
   UpdateKeys("Rotate", TRANSFORM_CHAN_ROTATE, false);

   return TOOLRESULT_DRAWALL;
}

//-------------------
//  MRotateToolType
//-------------------
MRotateToolType::MRotateToolType()
{
  m_RequiresSel = true;
}

int MRotateToolType::DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View)
{
  if (AZTEC_CAST(COpenGLWnd, View))
    return MGLRotateToolType::DrawTool(Select, ShiftState, View);
  
  return 0;
}

int MRotateToolType::onMouseDown(int X, int Y, const MShiftState &Shift)
{
  if (AZTEC_CAST(COpenGLWnd, g_CurView))
    return MGLRotateToolType::onMouseDown(X, Y, Shift);
  
  return TOOLRESULT_DRAWNONE;
}

int MRotateToolType::onMouseUp(int X, int Y, const MShiftState &Shift)
{
  if (AZTEC_CAST(COpenGLWnd, g_CurView))
    return MGLRotateToolType::onMouseUp(X, Y, Shift);
  
  return TOOLRESULT_DRAWNONE;
}

int MRotateToolType::onMouseMove(int X, int Y, const MShiftState &Shift)
{
  if (AZTEC_CAST(COpenGLWnd, g_CurView))
    return MGLRotateToolType::onMouseMove(X, Y, Shift);
  
  return TOOLRESULT_DRAWNONE;
}

