#include <AztecMainPCH.h>

#include "MToolType.h"

#include <params/MParameterFactory.h>

#include <gl/gl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//------------
//  MToolType
//------------

MToolType::MToolType() {
  m_hWnd = NULL;
  m_Dragging = false;
  m_PickedManip = 0;
  m_RequiresSel = false;

}

MToolType::~MToolType() {
}

std::string MToolType::getName() {
  return toolName;
}

void MToolType::setName(const std::string &name) {
  toolName = name;
}

bool MToolType::Is(MStr Str) {
  if (Str.compareNoCase(getName().c_str()) == 0)
    return true;
  
  return false;
}

void MToolType::initialise() {
}

bool MToolType::finish() {
  return true;
}

bool MToolType::cancel() {
  return true;
}

int MToolType::DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View) {
  return 1;
}
int MToolType::onMouseDown(int X, int Y, const MShiftState &Shift) {
  m_DownPos.x = (float)X;
  m_DownPos.y = (float)Y;
  m_CurPos.x = (float)X;
  m_CurPos.y = (float)Y;
  
  return TOOLRESULT_DRAWNONE;
}

int MToolType::onMouseUp(int X, int Y, const MShiftState &Shift) {
  m_UpPos.x = (float)X;
  m_UpPos.y = (float)Y;
  m_CurPos.x = (float)X;
  m_CurPos.y = (float)Y;
  
  return TOOLRESULT_DRAWNONE;
}

int MToolType::onMouseMove(int X, int Y, const MShiftState &Shift)
{
  if (Shift.m_Left || Shift.m_Mid || Shift.m_Right)
    m_Dragging = true;
  else
    m_Dragging = false;
  
  m_CurPos.x = (float)X;
  m_CurPos.y = (float)Y;
  
  return TOOLRESULT_DRAWNONE;
}

