// SegmentViewWnd.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "SegmentViewWnd.h"

#include "resource.h"

#include "MDLGlobs.h"
#include "DLgGlobs.h"
#include "MdlMsgs.h"

#include "UndoGeneral.h"

#include "KeyFuncMain.h"
#include "KeyFuncAnim.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define ZOOMIN_BUT  5001
#define ZOOMOUT_BUT  5002

/////////////////////////////////////////////////////////////////////////////
// CSegmentViewWnd

CSegmentViewWnd::CSegmentViewWnd() {
  m_Tracking = false;
}

CSegmentViewWnd::~CSegmentViewWnd() {
}

MBaseObjectPtr CSegmentViewWnd::createNew() {
  CSegmentViewWnd  *Wnd;
  
  Wnd = new CSegmentViewWnd;
  Wnd->setName(getName());
  
  return (MBaseObject*)Wnd;
}

BEGIN_MESSAGE_MAP(CSegmentViewWnd, CWnd)
//{{AFX_MSG_MAP(CSegmentViewWnd)
ON_WM_PAINT()
ON_WM_CREATE()
ON_WM_LBUTTONDOWN()
ON_WM_LBUTTONUP()
ON_WM_MBUTTONDOWN()
ON_WM_MBUTTONUP()
ON_WM_RBUTTONDOWN()
ON_WM_RBUTTONUP()
ON_WM_SIZE()
ON_WM_VSCROLL()
ON_WM_HSCROLL()
ON_WM_KEYDOWN()
ON_WM_CLOSE()
ON_WM_MOUSEMOVE()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

LRESULT CSegmentViewWnd::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) {

  if (message == MM_UPDATEVIEWPORTS || message == MM_UPDATECHANNELBAR) {
    ::SendMessage(g_MainDlg->m_hWnd, message, wParam, lParam);
  }

  return CWnd::WindowProc(message, wParam, lParam);
}

void CSegmentViewWnd::ViewCreate()
{
  MBaseViewWnd::ViewCreate();

  m_SegmentEditor.setAutoOrganise(false);
  m_SegmentEditor.setDrawTimeline(true);
  m_SegmentEditor.setHeadings(true);
  m_SegmentEditor.Create(NULL, "SegmentEditor", WS_CHILD | WS_VISIBLE, CRect(0,0,10,10), this, 10);
  m_SegmentEditor.SetScrollRange(0,200);

  RECT clientRect, rect;

  GetClientRect(&clientRect);

  rect.left = clientRect.right - ::GetSystemMetrics(SM_CXVSCROLL);
  rect.right = clientRect.right;
  rect.top = 32;
  rect.bottom = clientRect.bottom;

  m_VertScroll.Create(SBS_VERT | WS_VISIBLE, rect, this, 5003);

  rect.left = 0;
  rect.right = clientRect.right - ::GetSystemMetrics(SM_CXVSCROLL);
  rect.top = clientRect.bottom - ::GetSystemMetrics(SM_CYHSCROLL);
  rect.bottom = clientRect.bottom;

  m_HorzScroll.Create(SBS_HORZ | WS_VISIBLE, rect, this, 5003);


  rect.left = clientRect.left;
  rect.top = clientRect.top;
  rect.right = rect.left + 32;
  rect.bottom = rect.top + 32;

  m_ZoomIn.Create("But", BS_PUSHLIKE | BS_CHECKBOX | BS_OWNERDRAW | WS_VISIBLE, rect, this, ZOOMIN_BUT);
  m_ZoomIn.SetWindowText("In");
  rect.left += 32;
  rect.right += 32;
  m_ZoomOut.Create("But", BS_PUSHLIKE | BS_CHECKBOX | BS_OWNERDRAW | WS_VISIBLE, rect, this, ZOOMOUT_BUT);
  m_ZoomOut.SetWindowText("Out");

  m_ZoomIn.SetActionName("KSegmentViewZoomIn");
  m_ZoomOut.SetActionName("KSegmentViewZoomOut");
}

void CSegmentViewWnd::DrawView()
{
  MBaseViewWnd::DrawView();

  if (m_VertScroll.m_hWnd != NULL) {
    int pos = m_VertScroll.GetScrollPos();
    m_VertScroll.SetScrollRange(0, g_Scene->getTimeSegmentCount());
    m_VertScroll.SetScrollPos(pos);
  }
  if (!m_Tracking && m_HorzScroll.m_hWnd != NULL) {
    int pos = m_HorzScroll.GetScrollPos();
    m_HorzScroll.SetScrollRange( pos - 20, pos + 20);
    m_HorzScroll.SetScrollPos(pos);
  }


  ::InvalidateRect(m_SegmentEditor.m_hWnd, NULL, FALSE);
  ::SendMessage(m_SegmentEditor.m_hWnd, WM_PAINT, 0,0);


  RECT clientRect;
  HDC dc = ::GetDC(m_hWnd);

  GetClientRect(&clientRect);

  clientRect.left += 64;
  clientRect.bottom = clientRect.top + 32;
  ::FillRect(dc, &clientRect, (HBRUSH)::GetStockObject(GRAY_BRUSH));


  GetClientRect(&clientRect);

  ::ReleaseDC(m_hWnd, dc);
}

void CSegmentViewWnd::zoomIn() {
  int min, max;

  min = m_SegmentEditor.GetScrollMin();
  max = m_SegmentEditor.GetScrollMax();

  max = (float)(max - min) / 1.25 + 0.5 + min;

  if (max <= min + 2) {
    max = min + 3;
  }

  m_SegmentEditor.SetScrollRange(min, max);

  ::InvalidateRect(m_SegmentEditor.m_hWnd, NULL, FALSE);
  ::SendMessage(m_SegmentEditor.m_hWnd, WM_PAINT, 0,0);
}

void CSegmentViewWnd::zoomOut() {
  int min, max;

  min = m_SegmentEditor.GetScrollMin();
  max = m_SegmentEditor.GetScrollMax();

  max = 1.25 * (max - min) + 0.5 + min;

  if (max <= min + 2) {
    max = min + 3;
  }

  m_SegmentEditor.SetScrollRange(min, max);

  ::InvalidateRect(m_SegmentEditor.m_hWnd, NULL, FALSE);
  ::SendMessage(m_SegmentEditor.m_hWnd, WM_PAINT, 0,0);
}

void CSegmentViewWnd::scroll(int xAmount, int yAmount) {
  m_SegmentEditor.scroll(xAmount, yAmount);
}


DWORD CSegmentViewWnd::ViewPopupMenu(int x, int y)
{
  CMenu    Menu, AppMenu;
  CMenu    *Popup;
  DWORD    Choice;
  
  Menu.LoadMenu(IDR_SEGMENTEDITOR_POPUP);
  Popup = Menu.GetSubMenu(0);
  InitPopupMenu(Popup);
  
  Choice = Popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, x, y, this);
  
  Popup->DestroyMenu();
  
  bool     Update;
  int      Result;
  
  Result = HandlePopupCommand(Choice);
  
  // The command was handled, but the view was changed, so we must return.
  if (Result == -1)
    return 1;
  
  if (Result == 1)
    Update = true;
  else 
    Update = false;
  
  if (Update)
  {
    DrawView();
  }
  
  return Choice;
}

int CSegmentViewWnd::HandlePopupCommand(DWORD Cmd)
{
  int Result;
  
  Result = MBaseViewWnd::HandlePopupCommand(Cmd);
  
  if (Result) {
    return Result;
  }
  
  switch (Cmd)
  {
  case ID_POPUP_CREATEATIMESEGMENT:
    KAnimCreateTimeSegment();
    return 1;
  }
  
  return 0;
}



/////////////////////////////////////////////////////////////////////////////
// CSegmentViewWnd message handlers

void CSegmentViewWnd::OnPaint() 
{
  CPaintDC dc(this); // device context for painting
  
  DrawView();
}

int CSegmentViewWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
  if (CWnd::OnCreate(lpCreateStruct) == -1)
    return -1;
  
  return 0;
}


void CSegmentViewWnd::onMouseUp(int X, int Y, MShiftState Shift) {
  bool RequireUpdate;
  
  RequireUpdate = false;
  
  if (RequireUpdate)
  {
    g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
    g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);
  }
}

void CSegmentViewWnd::onMouseDown(int X, int Y, MShiftState Shift) {
  bool RequireUpdate;
  
  RequireUpdate = false;
  
  ::SetCurrentView(this);
  if (RequireUpdate)
  {
    g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
    g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);
  }
}

void CSegmentViewWnd::OnSize(UINT nType, int cx, int cy) 
{
  CWnd::OnSize(nType, cx, cy);
  
  RECT clientRect, rect;
  
  GetClientRect(&clientRect);

  m_PopupRect = clientRect;

  // go past the buttons
  clientRect.top += 32;

  if (::IsWindow(m_VertScroll.m_hWnd)) {
    rect.left = clientRect.right - ::GetSystemMetrics(SM_CXVSCROLL);
    rect.right = clientRect.right;
    rect.top = clientRect.top;
    rect.bottom = clientRect.bottom;

    clientRect.right = rect.left;
    
    m_VertScroll.MoveWindow(&rect);
  }
  
  if (::IsWindow(m_HorzScroll.m_hWnd)) {
    rect.left = clientRect.left;
    rect.right = clientRect.right;
    rect.top = clientRect.bottom - ::GetSystemMetrics(SM_CYHSCROLL);
    rect.bottom = clientRect.bottom;

    clientRect.bottom = rect.top;
    
    m_HorzScroll.MoveWindow(&rect);
  }

  if (::IsWindow(m_SegmentEditor.m_hWnd)) {
    m_SegmentEditor.MoveWindow(&clientRect);
  }


  DrawView();
  
}

void CSegmentViewWnd::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  int      ScrollPos;
  RECT     ClientRect;
  
  GetClientRect(&ClientRect);
  
  ScrollPos = m_VertScroll.GetScrollPos();
  
  if (nSBCode == SB_THUMBTRACK) {
    scroll(0, nPos - ScrollPos);
    ScrollPos = nPos;
  }
  if (nSBCode == SB_LINEUP) {
    ScrollPos -= 1;
    scroll(0, -1);
  }
  if (nSBCode == SB_LINEDOWN) {
    ScrollPos += 1;
    scroll(0, 1);
  }
  if (nSBCode == SB_PAGEUP) {
    ScrollPos -= ClientRect.bottom;
    scroll(0, -m_SegmentEditor.getNumberOfVisibleSegments());
  }
  if (nSBCode == SB_PAGEDOWN) {
    ScrollPos += ClientRect.bottom;
    scroll(0, m_SegmentEditor.getNumberOfVisibleSegments());
  }
  
  m_VertScroll.SetScrollPos(ScrollPos);
  DrawView();
  
  CWnd::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CSegmentViewWnd::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  int      ScrollPos;
  RECT     ClientRect;
  
  GetClientRect(&ClientRect);
  
  ScrollPos = m_HorzScroll.GetScrollPos();
  
  m_Tracking = false;
  if (nSBCode == SB_THUMBTRACK) {
    m_Tracking = true;
    scroll(nPos - ScrollPos, 0);
    ScrollPos = nPos;
  }
  if (nSBCode == SB_LINEUP) {
    ScrollPos -= 16;
    scroll(-1, 0);
  }
  if (nSBCode == SB_LINEDOWN) {
    ScrollPos += 16;
    scroll(1, 0);
  }
  if (nSBCode == SB_PAGEUP) {
    ScrollPos -= ClientRect.right;
    scroll(-4, 0);
  }
  if (nSBCode == SB_PAGEDOWN) {
    ScrollPos += ClientRect.right;
    scroll(4, 0);
  }
  
  m_HorzScroll.SetScrollPos(ScrollPos);

  DrawView();
  
  CWnd::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CSegmentViewWnd::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
  {
    bool s,a,c;
    MShiftState state = getShiftState();
    s = state.m_Shift;
    a = state.m_Alt;
    c = state.m_Ctrl;
    
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"General"))
      return;
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"View"))
      return;
  }
  
  CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CSegmentViewWnd::OnClose() 
{
  // Remove the Scene window fro the view list.
  
  g_ViewList.DeleteView(this);
  
  // CWnd::OnClose();
}

void CSegmentViewWnd::onMouseMove(int x, int y, MShiftState Shift) {
  ::SetCursor(LoadCursor(NULL, IDC_ARROW));
}

BOOL CSegmentViewWnd::PreTranslateMessage(MSG* pMsg) 
{
  return MBaseViewWnd::PreTranslateMessage(pMsg);
}
