function setWidth(component, width) {
  var size = component.getMinimumSize();
  size.width = width;
  component.setMinimumSize(size);
}

function createItem(container, caption, width) {
  var label = new MLabel(caption);
  var editBox = new MTextField();

  container.addComponent(label);
  container.addComponent(editBox);

  setWidth(editBox, width);
}

function scrolledContainerExample() {

  var mainWindow = new MWindow();
  // the flow layout takes three args, the x and y margins, 
  // and then the number of components per row
  mainWindow.setLayoutManager(new MBorderLayout());

  var scroller = new MScrolledContainer();
  mainWindow.addComponent(scroller, MBorderLayout.CENTRE);

//  var container = new MContainer();
//  scroller.addComponent(container);
  scroller.setLayoutManager(new MFlowLayout(2,2,2));
  createItem(scroller, "Label 1", 150);
  createItem(scroller, "Label 2", 300);
  createItem(scroller, "Label 3", 50);

  mainWindow.setVisible(true);	

}

scrolledContainerExample();