#ifndef PRIMPARTICLE_H
#define PRIMPARTICLE_H

#include "MShapeObject.h"
#include "MMesh.h"

#include "params/MObjectParameter.h"
#include "params/MIntParameter.h"
#include "params/MFloatParameter.h"
#include "params/MBooleanParameter.h"
#include "MScriptingSupport.h"

#include <list>
#include <vector>

class MPrimitiveParticle;
typedef Aztec::MRefCountedPtr<MPrimitiveParticle> MParticlePtr;

typedef std::vector< float > particleParamType;

class MPrimitiveParticle : public Aztec::MShapeObject {
protected:
  Aztec::MObjectParameterPtr m_InMeshParam;
  bool isPlaying;
  int particleHandle;
  double lastEvaluatedTime;

  Aztec::MFloatParameterPtr stepRatePtr;
  Aztec::MBooleanParameterPtr loopAnimPtr;
  Aztec::MIntParameterPtr maxParticlesPtr;

  // Evaluate the action list.  This is executed for each time step in an animation.
  void evaluateActions(Aztec::MSceneObjectPtr sceneObj, Aztec::MSceneViewFlags ViewFlags);

public:	
	// Construction/Destruction
	MPrimitiveParticle();
	virtual ~MPrimitiveParticle();
	
	// Class related
	virtual MStr getClassName() {return MStr("MPrimitiveParticle");};
	virtual MStr getParentClassName() {return MStr("MBaseObject");};
	virtual Aztec::MBaseObjectPtr createNew();

	void onParameterChange(Aztec::MParameterObjectPtr param);

	// Animation Keying
	void updateKey(int Time, DWORD Channel, bool CreateKey);
	
  // MShapeObject methods
	Aztec::MMeshPtr convertToMesh();
    bool drawObject(const Aztec::MBaseObjectPtr &baseObj, Aztec::MSceneViewFlags ViewFlags);

	// Scripting support
	Aztec::MScriptingSupportPtr getScriptObject();

	// Particle system specific
	class actionType {
	public:
		enum actionEnum { firstActionEnum = 0, color = firstActionEnum, colorDomain, size, sizeDomain, startingAge, timeStep,
			velocity, velocityDomain, vertexB, vertexBTracks, avoid, bounce, copyVertexB,
			damping, explosion, follow, gravitate, gravity, jet, killOld, matchVelocity,
			move, orbit, randomAccel, randomDisplace, randomVelocity, restore, sink,
			sinkVelocity, source, speedLimit, targetColor, targetSize, targetVelocity,
			vertex, vortex, lastActionEnum = vortex
		};

		actionEnum action;
		particleParamType m_params;

	};
	typedef std::vector< actionType > actionListType;
	actionListType m_ActionList;

	static const char *actionEnumToString(actionType::actionEnum a);
	static float actionEnumToFloat(actionType::actionEnum a);
	static actionType::actionEnum floatToActionEnum(float f);

protected:

	// Particle system evaluation routines
	void getDomainEntries(PDomainEnum domain, int startIndex, const particleParamType &entries, float *a);
	void evaluateColor(const particleParamType &entries);
	void evaluateColorD(const particleParamType &entries);
	void evaluateVelocity(const particleParamType &entries);
	void evaluateVelocityDomain(const particleParamType &entries);
	void evaluateSize(const particleParamType &entries);
	void evaluateSizeD(const particleParamType &entries);
	void evaluateAvoid(const particleParamType &entries);
	void evaluateBounce(const particleParamType &entries);
	void evaluateSource(const particleParamType &entries);
	void evaluateGravity(const particleParamType &entries);
	void evaluateSink(const particleParamType &entries);
	void evaluateVortex(const particleParamType &entries);
	void evaluateKillOld(const particleParamType &entries);

};


#endif


