#include "stdafx.h"
#include "dialogs/VortexEditDlg.h"

CVortexEditDlg::CVortexEditDlg(void) :
	cx(0), cy(0), cz(0),
	ax(0), ay(0), az(0),
	mag(1.0f), eps(P_EPS), maxrad(P_MAXFLOAT)
{
}

CVortexEditDlg::~CVortexEditDlg(void)
{
}

void CVortexEditDlg::setEntriesFromMembers()
{
	char buf[32];

	SetDlgItemText(IDC_VORTEX_CENTER_X_EDIT, _gcvt(cx, 7, buf));
	SetDlgItemText(IDC_VORTEX_CENTER_Y_EDIT, _gcvt(cy, 7, buf));
	SetDlgItemText(IDC_VORTEX_CENTER_Z_EDIT, _gcvt(cz, 7, buf));

	SetDlgItemText(IDC_VORTEX_AXIS_X_EDIT, _gcvt(ax, 7, buf));
	SetDlgItemText(IDC_VORTEX_AXIS_Y_EDIT, _gcvt(ay, 7, buf));
	SetDlgItemText(IDC_VORTEX_AXIS_Z_EDIT, _gcvt(az, 7, buf));

	SetDlgItemText(IDC_VORTEX_MAGNITUDE_EDIT, _gcvt(mag, 7, buf));
	SetDlgItemText(IDC_VORTEX_EPSILON_EDIT, _gcvt(eps, 7, buf));
	SetDlgItemText(IDC_VORTEX_MAX_RADIUS_EDIT, _gcvt(maxrad, 7, buf));
}

void CVortexEditDlg::setEntriesFromParams(int startIndex, particleParamType &entries)
{
	int numParams = entries.size();

	cx = entries[0]; cy = entries[1]; cz = entries[2];
	ax = entries[3]; ay = entries[4]; az = entries[5];

	mag = 1.0f;
	eps = P_EPS;
	maxrad = P_MAXFLOAT;

	if (numParams > 6) {
		mag = entries[6];
		if (numParams > 7) {
			eps = entries[7];
			if (numParams > 8) {
				maxrad = entries[8];
			}
		}
	}

	setEntriesFromMembers();
}

void CVortexEditDlg::getParamsFromEntries(particleParamType &params)
{
	char buf[64];

	// Get the bounce specific parameters
	GetDlgItemText(IDC_VORTEX_CENTER_X_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_VORTEX_CENTER_Y_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_VORTEX_CENTER_Z_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));

	GetDlgItemText(IDC_VORTEX_AXIS_X_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_VORTEX_AXIS_Y_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_VORTEX_AXIS_Z_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));

	GetDlgItemText(IDC_VORTEX_MAGNITUDE_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_VORTEX_EPSILON_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_VORTEX_MAX_RADIUS_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
}

LRESULT CVortexEditDlg::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	setEntriesFromMembers();

	return 0;
}

