#ifndef MTHREAD_HEADER
#define MTHREAD_HEADER

#ifdef WIN32
#include <process.h>
#include <windows.h>
typedef int pid_t;
#else
#include <sys/types.h>  
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/wait.h>   
#include <signal.h>     
#include <stdio.h>      
#include <unistd.h>     
#endif


#define THREADSTACKSIZE (2048*4)

void threadCall(void *voidThread);   // Global entry for WIN32
void sig_chld(int signo);            // SigChld handler for UNIX

class MThread {                     
  public:
    static int ThreadStack;
    pid_t      threadID;

	MThread::MThread();
    virtual MThread::~MThread();
    
	/*
	 * Initialize threads(success=0)
	 *
	 * @return  Success is 0
	 */
    static int   init(); 
	
	/**
	 * Cleanup threads
	 *
	 * @return  Success is 0
	 */
    static int   done() { return 0; }
    
    /*
	 * Give up time slice to process
	 * 
	 * @seconds  Minimum time to give process
	 */
    static void  sleep(int milliseconds);

	/**
	 * Spawn the child thread
	 *
	 * @return  Success returns pid, <0 for failure
	 */
    int          spawn();
	
	/**
	 * This is the function run by spawn, it should be defined in the
	 * derived class of MThread.
	 */
    virtual void main() = 0;             
};

#endif 

