// PovrayPlugin.cpp : Defines the entry point for the DLL application.
//

#include "StdAfx.h"
#include "PovrayPlugin.h"
#include "PovrayTranslator.h"
#include "PovrayRenderer.h"


#ifdef WIN32


BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}

POVRAYPLUGIN_API int ModQueryVersion(long *Dest) {
   memcpy(Dest, MODEL_API_VERSION, 4);
   return 1;
}

POVRAYPLUGIN_API int ModQueryDesc(char *Dest) {
   strcpy(Dest, "This is the PovRay 3.5 export DLL");
   return 1;
}

POVRAYPLUGIN_API int ModQueryCount() {
   return 2;
}

POVRAYPLUGIN_API int ModRegister(Aztec::MSystemManager *SysMan, int IDNo) {

   switch (IDNo)
   {
   case 0:
      return SysMan->getPluginManager()->registerSceneTranslator(new PovrayTranslator());
      break;
   case 1:
      SysMan->getPluginManager()->registerRenderer(new PovrayRenderer());
      return 1;
      break;
   }

   return 0;
}


#endif
