#include "Stdafx.h"

#include "Plane.h"

#include "MBaseObject.h"
#include "MShapeObject.h"
#include "MMesh.h"
#include "MEditableMesh.h"

#include <params/MParameterFactory.h>

//----------------------------------------------------------------------------------------
//  Plane
//----------------------------------------------------------------------------------------
Plane::Plane() {
  addParameter(wParam = Aztec::MParameterFactory::createFloat("w", "width", "Width"));
  addParameter(hParam = Aztec::MParameterFactory::createFloat("h", "height", "Height"));
  addParameter(divwParam = Aztec::MParameterFactory::createInteger("dw", "divw", "Width Divisions"));
  addParameter(divhParam = Aztec::MParameterFactory::createInteger("dh", "divh", "Height  Divisions"));
  
  wParam->setValueFloat(100);
  hParam->setValueFloat(100);
  divwParam->setValueInteger(3);
  divhParam->setValueInteger(3);
  
  divw = -1;
  divh = -1;
  width = 0;
  height = 0;
  
  setFlag(OBJECTFLAG_NOCOMPONENTS);
  
  lastMesh = NULL;
  
}

Plane::~Plane()
{
  lastMesh = NULL;
}

Aztec::MBaseObjectPtr Plane::createNew() {
  Aztec::MRefCountedPtr<Plane> NewObj;
  
  NewObj = new Plane();
  NewObj->m_ParamList->setFromList(getParamList());
  
  return NewObj;
}

// MBaseObject methods
bool Plane::doUpdateObject() {
  MMeshCreator::doUpdateObject();
  
  getOutputParameter()->setValue(convertToMesh());

  return true;
}

#include <math.h>


Aztec::MMeshPtr Plane::convertToMesh() {

  if (lastMesh == NULL ||
      wParam->getValue() != width ||
      hParam->getValue() != height ||
      divwParam->getValue() != divw ||
      divhParam->getValue() != divh) {

    width = wParam->getValue();
    height = hParam->getValue();
    divw = divwParam->getValue();
    divh = divhParam->getValue();

    Aztec::MEditableMeshPtr mesh = new Aztec::MEditableMesh;
    float radius = 5.0;

    if (divw > 0 && divh > 0) {
      for (int y = 0; y <= divh; ++y) {
        double yp = -height/2 + (double)y * height / divh;
        for (int x = 0; x <= divw; ++x) {
          double xp = -width/2 + (double)x * width / divw;
          mesh->addVertex(xp, yp, 0.0);
        }
      }

      for (int y = 0; y < divh; ++y) {
        for (int x = 0; x < divw; ++x) {
          int a = y * (divw+1) + x;
          int b = a + 1;
          int c = b + divw + 1;
          int d = c - 1;
          mesh->addTriangle(a, b, c);
          mesh->addTriangle(a, c, d);
          mesh->unsetEdgeFlag(a, c, EDGE_VISIBLE);
        }
      }
      
    }

    // now make a read only copy of this mesh.
    Aztec::MMeshPtr realMesh = new Aztec::MMesh(mesh);
    realMesh->calculateNormals();

    // now take our mesh, and rescale it to use it as a UV map.
    if (divw > 0 && divh > 0) {
      int index = 0;
      for (int y = 0; y <= divh; ++y) {
        double yp = (double)y / divh;
        for (int x = 0; x <= divw; ++x) {
          double xp = (double)x / divw;
          mesh->setVertexPosition(index, Aztec::MVector3(xp, yp, 0));
          ++index;
        }
      }
    }

    realMesh->setTextureMesh(mesh);

    // now cache the mesh for use later.
    lastMesh = realMesh;
  }

  return lastMesh;
}

