#ifndef LWOTRANSLATOR_H
#define LWOTRANSLATOR_H

#include <translator/MSceneTranslator.h>

#include <stdio.h>
#include <string>
using std::string;

using namespace Aztec;


#define LW_MAX_NAME_LEN 1024

struct Vec3Df 
{ 
  float x,y,z; 
};


struct poly 
{
  unsigned short numvert;  // number of vertices
  unsigned short *vert;    // array of unsigned shorts
  signed short surf;       // number of the surface
};


struct lwoSurface
{
  char *name;
  float r,g,b;
};


class MLWOTranslator : public MSceneTranslator {
protected:
  
public:
  MLWOTranslator();
  virtual ~MLWOTranslator();
  
  // Class related
  virtual MStr getClassName() {return MStr("LWOTranslator");};
  virtual MStr getParentClassName() {return MStr("MSceneTranslator");};
  virtual MTranslatorPtr createNew() const;
  
  std::string getFilter() { return "*.LWO"; }
  std::string getFilterDescription() { return "Lightwave Model Files"; }
  virtual bool canImport() {return true;};
  virtual bool canExport() {return false;};
  virtual bool canImportFile(MStr Filename);
  
  virtual bool importFile(MStr Filename, MScenePtr Scene);
  virtual bool exportFile(MStr Filename, MScenePtr Scene);

private:
  // Extra functions for importing 
  bool read_lwo(const char *filename, Vec3Df *&AllPts, poly **&AllPolys, lwoSurface *&AllSurfs, int &pt_count, int &poly_count, int &surf_count);
  float rev(float &value);
  signed long rev(signed long &value);
  unsigned long rev (unsigned long &value);
  signed short rev(signed short &value);
  unsigned short rev(unsigned short &value);
  void read_chunk_PNTS(FILE *lwo_file, Vec3Df *&AllPts, int &pt_count);
  void read_chunk_POLS(FILE *lwo_file, poly **&AllPolys, int &poly_count);
  void read_chunk_SRFS(FILE *lwo_file, lwoSurface *&AllSurfs, int &surf_count);
  void read_chunk_SURF(FILE *lwo_file, lwoSurface *&AllSurfs, const int surf_count);
  void read_chunk(FILE *lwo_file, Vec3Df *&AllPts, poly **&AllPolys, lwoSurface *&AllSurfs, int &pt_count, int &poly_count, int &surf_count);
};

#endif
