#ifndef PCDTRANSLATOR_H
#define PCDTRANSLATOR_H

#include <translator/MImageTranslator.h>

using namespace Aztec;



class MPCDTranslator : public MImageTranslator {
protected:

public:
   MPCDTranslator();
   virtual ~MPCDTranslator();

   // Class related
   virtual MStr getClassName() {return MStr("MPCDTranslator");};
   virtual MStr getParentClassName() {return MStr("MImageTranslator");};
   virtual MTranslatorPtr createNew() const;

   std::string getFilter() { return "*.PCD"; }
   std::string getFilterDescription() { return "Photo CD Images"; }
   virtual bool canImport() {return true;};
   virtual bool canExport() {return false;};
   virtual bool canImportFile(MStr Filename);

   virtual bool importFile(MStr Filename, MImagePtr Image);
   virtual bool exportFile(MStr Filename, MImagePtr Image);
};


#endif
