#include "StdAfx.h"
#include "DevilTranslator.h"

#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>

#ifndef WIN32
  #include <sys/param.h>
  #define MAX_PATH MAXPATHLEN
#endif

#include <IL/il.h>

#include <assert.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


DevilTranslator::DevilTranslator(FileType type)
{
  fileType = type;

  switch (type) {
  case BMP:
    setup("Bitmap files", "*.bmp", "BMPTranslator", true, true, IL_BMP);
    break;
  case CHEAD:
    setup("Chead files", "*.chead", "CheadTranslator", true, true, IL_CHEAD);
    break;
  case JPG:
    setup("JPEG files", "*.jpg;*.jpeg", "JPGTranslator", true, true, IL_JPG);
    break;
  case PCX:
    setup("PCX files", "*.pcx", "PCXTranslator", true, true, IL_PCX);
    break;
  case PNG:
    setup("Portable Nework Graphic files", "*.png", "PNGTranslator", true, true, IL_PNG);
    break;
  case PNM:
    setup("PNM files", "*.pnm", "PNMTranslator", true, true, IL_PNM);
    break;
  case RAW:
    setup("RAW files", "*.raw", "RAWTranslator", true, true, IL_RAW);
    break;
  case SGI:
    setup("SGI files", "*.sgi", "SGITranslator", true, true, IL_SGI);
    break;
  case TGA:
    setup("Targa files", "*.tga", "TGATranslator", true, true, IL_TGA);
    break;
  case TIF:
    setup("TIFF files", "*.tif;*.tiff", "TIFTranslator", true, true, IL_TIF);
    break;
  default:
    setup("", "", "", false, false, 0);
    assert(0);
  }
}

DevilTranslator::~DevilTranslator()
{
}


MStr DevilTranslator::getClassName() {
  return className.c_str();
}

Aztec::MTranslatorPtr DevilTranslator::createNew() const {
  DevilTranslator   *NewTranslator;
  
  NewTranslator = new DevilTranslator(fileType);
  
  return NewTranslator;
}

std::string DevilTranslator::getFilter() {
  return filter;
}

std::string DevilTranslator::getFilterDescription() {
  return filterDesc;
}

bool DevilTranslator::canImport() {
  return isImportable;
}

bool DevilTranslator::canExport() {
  return isExportable;
}

bool DevilTranslator::canImportFile(MStr Filename) {
  // if we can't import at all, bail out straight away.
  if (!isImportable) {
    return false;
  }

  // Extract the extension from the filename, and compare it against our filter.
  MStr ext;
  Filename.SplitPath(NULL, NULL, NULL, &ext);
  ext.toLower();

  if (filter.find(ext.c_str()) != std::string::npos) {
    // If the extension is present, then we proceed to check to see
    // if the image library can load it.
    Aztec::MImagePtr image = new Aztec::MImage;

    // The only real way we have of testing if we can import something is 
    // to actually import it.
    return importFile(Filename, image);
  } else {
    return false;
  }

}


bool DevilTranslator::importFile(MStr Filename, Aztec::MImagePtr Image) {
   if (Image == NULL) return false;

   int      Width, Height;
   ILuint   Img;

   Filename.Replace('/', '\\');

   // Generate an image handle and load the requested image
   ilGenImages(1, &Img);
   ilBindImage(Img);

   if (!ilLoadImage((char*)(LPCTSTR)Filename))
   {
       ilDeleteImages(1, &Img);
       return false;
   }

   // Convert to 24 BPP
   ilConvertImage(IL_RGB, IL_UNSIGNED_BYTE);

   Width  = ilGetInteger(IL_IMAGE_WIDTH);
   Height = ilGetInteger(IL_IMAGE_HEIGHT);

   Image->setSize(Width, Height);

   ilCopyPixels(0, 0, 0, Width, Height, 1, IL_RGB, IL_UNSIGNED_BYTE, Image->getPixelData());

   // Delete the IL image handle
   ilDeleteImages(1, &Img);

   // because BMP's are stored upside down, we have to flip them for some off 
   // reason. I would have thought that devil would have done that.
   if (fileType == BMP) {
     Image->flipVertical();
   }

   return true;
}


bool DevilTranslator::exportFile(MStr Filename, Aztec::MImagePtr image) {
  // if we can't export, then just bail out straight away.
  if (!isExportable) {
    return false;
  }

  if (image == NULL) {
    return false;
  }

  ILuint   Img;
  
  // Generate an image handle and load the requested image
  ilGenImages(1, &Img);
  ilBindImage(Img);
  
  // devile xpects the image to be upside down for some reason. Odd.
  image->flipVertical();
  ilTexImage(image->getWidth(), image->getHeight(), 1, 3, IL_RGB, IL_UNSIGNED_BYTE, image->getPixelData());
  image->flipVertical();

  char buf[MAX_PATH];
  ILenum error = IL_NO_ERROR;
  strcpy(buf, Filename.c_str());

  ilEnable(IL_FILE_OVERWRITE);

  if (!ilSave(devilID, buf)) {
    error = ilGetError();
  }

  // Delete the IL image handle
  ilDeleteImages(1, &Img);

  return error == IL_NO_ERROR;
}

void DevilTranslator::setup(const std::string &filterDesc,
                            const std::string &filter, 
                            const std::string &className, 
                            bool isImportable, 
                            bool isExportable, 
                            unsigned int devilID)
{
  this->filter = filter;
  this->filterDesc = filterDesc;
  this->className = className;
  this->isImportable = isImportable;
  this->isExportable = isExportable;
  this->devilID = devilID;
}

