#ifndef MGLMoveToolType_Header
#define MGLMoveToolType_Header

#include <tools/MXYZToolType.h>

namespace AztecGUI {

  class MGLMoveToolType : public MXYZToolType {
  public:
    MGLMoveToolType();

    // MTool type methods
    std::string getName();
    bool cancel();
    bool inProgress();
    virtual int drawTool(bool Select, const Aztec::MComponentPtr &comp);
    virtual int onMouseDown(const Aztec::MMouseEvent &event);
    virtual int onMouseUp(const Aztec::MMouseEvent &event);
    virtual int onMouseMove(const Aztec::MMouseEvent &event);
    virtual int getDefaultManip();

  protected:
    Aztec::MVector3 m_MoveStart;
    
    typedef enum { SCREEN, XAXIS, YAXIS, ZAXIS } ManipAxis;
    
    // This is the axis that the middle manipulator is currently
    // oriented to.
    ManipAxis middleManipAxis;

    void transformSelection(const Aztec::MComponentPtr &component, const Aztec::MVector3 &worldOffset);
    void endTransform(const Aztec::MComponentPtr &component);

    void transformSelection3D(const Aztec::MVector3 &worldOffset);
    void transformSelectionUV(const Aztec::MVector3 &worldOffset);


  };

}

#endif

