#include <Aztec3DPCH.h>

#include <functions/edit/VisibilityFunctions.h>

// Aztec2 includes
#include <views/AztecViewManager.h>
#include <utils/SceneFunctions.h>

// AztecLib includes
#include <MScene.h>
#include <MSystemManager.h>
#include <MUIManager.h>


namespace AztecGUI {


  class SetKeyOnSelected {
  public:
    SetKeyOnSelected(const std::string &paramName, long newKeyTime) {
      name = paramName;
      time = newKeyTime;
    }

    void operator()(const Aztec::MScenePtr &scene, const Aztec::MTreeObjectNodePtr &node) {
      Aztec::MNamedObjectPtr namedObj = AZTEC_CAST(Aztec::MNamedObject, node->getObject());

      if (namedObj != NULL) {
        Aztec::MParameterObjectPtr paramObj = namedObj->getParamList()->getParameter(name.c_str());

        if (paramObj != NULL) {
          paramObj->createKeyAt(time);
        } else {
          Aztec::MSystemManager::getInstance()->logOutput("Warning: Object '%s' does not have a parameter named '%s'", namedObj->getName().c_str(), name.c_str());
        }
      }
    }

  private:
    std::string name;
    long time;
  };

  static int animateKeySelected(const StringVector &args, std::string &result) {
    if (args.size() == 0) {
      Aztec::MSystemManager::getInstance()->logOutput("Error: animateKeySelected needs at least one argument to specify which type of key to set. e.g. Scene.animateKeySelected('Translate', 'Rotate') to set a key on both the translate and rotate keys.");
      return FunctionManager::FAIL;
    }

    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();
    for (int i = 0; i < args.size(); ++i) {
      applyToObjects(scene, scene->getObjectList(), ifSelectedCriteria, SetKeyOnSelected(args[i], scene->getTime()));
    }

    AztecViewManager::redrawAllViews();

    return FunctionManager::SUCCEED;
  }

  void registerAnimationFunctions(FunctionManager &man) {

    man.registerFunction("animateKeySelected", animateKeySelected);

  }


}

