#include <Aztec3DPCH.h>

#include <functions/edit/TimeFunctions.h>

// Aztec2 includes
#include <views/AztecViewManager.h>

// AztecLib includes
#include <MScene.h>
#include <MSystemManager.h>


namespace AztecGUI {

  static int timeFrameNext(const StringVector &args, std::string &result) {
    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();
    scene->setTime( scene->getTime() + (int)scene->getTicksPerFrame() );

    AztecViewManager::redrawAllViews();
    return FunctionManager::SUCCEED;
  }

  static int timeFramePrev(const StringVector &args, std::string &result) {
    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();
    scene->setTime( scene->getTime() - (int)scene->getTicksPerFrame() );

    AztecViewManager::redrawAllViews();
    return FunctionManager::SUCCEED;
  }

  static int timeFrameNextKey(const StringVector &args, std::string &result) {
    // TODO: implement this properly.
    return timeFrameNext(args, result);
  }
  
  static int timeFramePrevKey(const StringVector &args, std::string &result) {
    // TODO: implement this properly.
    return timeFrameNext(args, result);
  }
  
  static int timePlay(const StringVector &args, std::string &result) {
    return FunctionManager::FAIL;
  }
  
  static int timeGetFrame(const StringVector &args, std::string &result) {
    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();

    result = Aztec::intToStr(scene->tickToFrame(scene->getTime())).c_str();
    return FunctionManager::SUCCEED;
  }
  
  static int timeGetTick(const StringVector &args, std::string &result) {
    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();

    result = Aztec::intToStr(scene->getTime()).c_str();
    return FunctionManager::SUCCEED;
  }
  
  static int timeSetFrame(const StringVector &args, std::string &result) {
    if (args.size() != 1) {
      Aztec::MSystemManager::getInstance()->logOutput("Error: toolSetCurrent() - requires one arguments. e.g: scene.timeSetFrame(65)");
      return FunctionManager::FAIL;
    }

    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();
    scene->setTime(scene->frameToTick(Aztec::strToInt(args[0].c_str())));

    return FunctionManager::FAIL;
  }
  
  static int timeSetTick(const StringVector &args, std::string &result) {
    if (args.size() != 1) {
      Aztec::MSystemManager::getInstance()->logOutput("Error: toolSetCurrent() - requires one arguments. e.g: scene.timeSetFrame(65)");
      return FunctionManager::FAIL;
    }

    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();
    scene->setTime(Aztec::strToInt(args[0].c_str()));

    return FunctionManager::FAIL;
  }
  
  static int timeGetFPS(const StringVector &args, std::string &result) {
    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();

    result = Aztec::intToStr(scene->getFramesPerSecond()).c_str();
    return FunctionManager::SUCCEED;
  }

  static const char *TIME_CATEGORY = "Time";

  void registerTimeFunctions(FunctionManager &man) {

    man.registerFunction("timeFrameNext", timeFrameNext, TIME_CATEGORY, "Goto next frame");
    man.registerFunction("timeFramePrev", timeFramePrev, TIME_CATEGORY, "Goto previous frame");
    man.registerFunction("timeFrameNextKey", timeFrameNextKey, TIME_CATEGORY, "Goto next keyed frame");
    man.registerFunction("timeFramePrevKey", timeFramePrevKey, TIME_CATEGORY, "Goto previous keyed frame");
    man.registerFunction("timePlay", timePlay, TIME_CATEGORY, "Play the Animation");
    man.registerFunction("timeGetFrame", timeGetFrame);
    man.registerFunction("timeGetTick", timeGetTick);
    man.registerFunction("timeSetFrame", timeSetFrame);
    man.registerFunction("timeSetTick", timeSetTick);
    man.registerFunction("timeGetFPS", timeGetFPS);
  }


}

