
#ifndef QComponent_Header
#define QComponent_Header

#include <string>
#include <iostream>

#include <qwidget.h>
#include <qpainter.h>

#include "gui/MComponent.h"


/**
 * Custom QWidget class for passing signals into AztecGUI
 */
class CQComponent_ : public QWidget {

  // Qt MOC pre-processor macro
  Q_OBJECT

public:
  CQComponent_(QWidget* parent, const Aztec::MComponentPtr ref)
    : QWidget(parent, 0, WRepaintNoErase|WResizeNoErase),
      m_Ref(ref) {
    // Don't clear the background when repainting this widget.
    setBackgroundMode(Qt::NoBackground);

    // Connect the signals
    connect(this, SIGNAL(resizeEvent(QResizeEvent*)), SLOT(onResize(QResizeEvent*)));
    connect(this, SIGNAL(showEvent(QShowEvent*)), SLOT(onShow(QShowEvent*)));
    connect(this, SIGNAL(paintEvent(QPaintEvent*)), SLOT(onPaint(QPaintEvent*)));
    connect(this, SIGNAL(mousePressEvent(QMouseEvent*)), SLOT(onMousePress(QMouseEvent*)));
    connect(this, SIGNAL(keyPressEvent(QKeyEvent*)), SLOT(onKeyPress(QKeyEvent*)));
    connect(this, SIGNAL(keyReleaseEvent(QKeyEvent*)), SLOT(onKeyRelease(QKeyEvent*)));

    // To receive key presses we should be able to focus on the widget
    setFocusPolicy(QWidget::StrongFocus);

    // Install a custom event filter for this widget
    //parentWidget()->installEventFilter(this);
  };

  ~CQComponent_() {
    //parentWidget()->removeEventFilter(this);
    m_Ref = 0l;
  }

protected:
  /**
   * Custom event filter rules
   */
  bool eventFilter(QObject* obj, QEvent* ev) {

    if (ev->type() == QEvent::MouseButtonPress) {
      QMouseEvent* e = (QMouseEvent*)ev;

      if (e->button() == QMouseEvent::LeftButton &&
         (e->state() & QMouseEvent::AltButton) != 0) {
        std::cout << "MComponent: The clicked widget is a " << obj->className() << std::endl;
        //std::cout << "The widget name is " << obj->name() << std::endl;

/*        MMouseEvent event(MMouseEvent::LBUTTON_DOWN, , MPoint2D(,), state, this);
        m_Ref->onMousePressed(event);*/

        return true;
      }
    }

    //return QMainWindow::eventFilter(obj, ev);
    return false;
  };

protected:
  /**
   * A reference to the MComponent that is using us
   */
  Aztec::MComponentPtr m_Ref;

signals:
  /**
   * Qt signals
   */
  void resizeEvent(QResizeEvent* ev);
  void showEvent(QShowEvent* ev);
  void paintEvent(QPaintEvent* ev);
  void mousePressEvent(QMouseEvent* ev);
  void keyPressEvent(QKeyEvent* ev);
  void keyReleaseEvent(QKeyEvent* ev);

protected slots:
  /**
   * These methods pass the signals into AztecGUI
   */
  void onResize(QResizeEvent* ev) {
    QWidget::resizeEvent(ev);
    m_Ref->onResize(ev->size().width(), ev->size().height());
  };

  void onShow(QShowEvent* ev) {
    QWidget::showEvent(ev);
    //lower();
    m_Ref->onShow();
  };

  void onPaint(QPaintEvent* ev) {
    QWidget::paintEvent(ev);
    m_Ref->onPaint();
  }

  void onMousePress(QMouseEvent* ev) {
//    QWidget::mousePressEvent(ev);

    std::cout << "onMousePress event!" << std::endl;

    // TODO: Handle MApp mouse press event
//    MMouseEvent event(MMouseEvent::LBUTTON_DOWN, ???, MPoint2D(,), state, this);
//    m_Ref->onMousePressed(event);
  };

  void onKeyPress(QKeyEvent* ev) {
    std::cout << "MComponent::onKeyPress" << std::endl;
  }

  void onKeyRelease(QKeyEvent* ev) {
    std::cout << "MComponent::onKeyRelease" << std::endl;
  }

};


#endif

