
#ifndef QListView_Header
#define QListView_Header

#include <string>
#include <iostream>

#include <qlistview.h>

#include <gui/MTreeControl.h>


/**
 * Custom QListView class for passing signals into AztecGUI
 */
class CQListView_ : public QListView {

  // Qt MOC pre-processor macro
  Q_OBJECT

public:
  CQListView_(QWidget* parent, const Aztec::MTreeControlPtr ref)
    : QListView(parent),
      m_Ref(ref) {
    // Connect the signals
    connect(this, SIGNAL(resizeEvent(QResizeEvent*)), SLOT(onResize(QResizeEvent*)));
    connect(this, SIGNAL(showEvent(QShowEvent*)), SLOT(onShow(QShowEvent*)));

    // Remove the frame, doesn't look good when having double bevels
    setFrameStyle(QFrame::NoFrame);

    // Win32 doesn't take care of columns yet, so do it implicitly in this Qt version
    m_Ref->m_col = addColumn("Header");

    // Additional setup
    setRootIsDecorated(true);
  };

  ~CQListView_() {
    m_Ref = 0l;
  }

protected:
  /**
   * A reference to the MTreeControl
   */
  Aztec::MTreeControlPtr m_Ref;

signals:
  /**
   * Qt signals
   */
  void resizeEvent(QResizeEvent* ev);
  void showEvent(QShowEvent* ev);

protected slots:
  /**
   * These methods pass the signals to AztecGUI
   */
  void onResize(QResizeEvent* ev) {
    QListView::resizeEvent(ev);
    m_Ref->onResize(ev->size().width(), ev->size().height());
  };

  void onShow(QShowEvent* ev) {
    QListView::showEvent(ev);
    m_Ref->onShow();
  };

};


#endif

