/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <AztecGUICommonPCH.h>

#include <gui/qt3/MButtonImpl.h>
#include <gui/qt3/MContainerImpl.h>
#include <gui/qt3/MAppImpl.h>

#include <gui/qt3/QButton_.moc>

#include <iostream>


namespace Aztec {

  MButton::MButton( const std::string &caption, 
                    const std::string &command, 
                    MSize2D prefSize) 
    : MComponent(caption),
      m_Caption(caption),
      m_Command(command),
      minButSize(-1,-1)
  {

    if (prefSize.getWidth() != -1 || prefSize.getHeight() != -1) {
      setPreferredSize(prefSize);
      setMinimumSize(prefSize);
    }

  }

  MButton::~MButton() {
  }

  bool MButton::createImpl() {
    MApp* app;
    QWidget* parentWnd = 0l;

    // Get the parent widget handle, so we can create our button
    if (m_Parent != 0l) {
      parentWnd = m_Parent->getHandle();
    }

    app = MApp::getInstance();

    // create the actual widget
    m_Handle = new CQPushButton_(parentWnd, this);

    // if it succeeded, update everything
    if (m_Handle != 0) {
      // Register this widget with the application
      app->registerComponent(m_Handle, this);

      // Call the create event handler
      onCreate();

      // Do NOT outcomment this visibility call,
      // It makes other windows flash (you'll understand
      // why when seeing this in action)
      //setVisible(true);

      /*::UpdateWindow(m_hWnd);*/
      QPushButton* but = dynamic_cast<QPushButton*>(m_Handle);
      but->setText(m_Caption.c_str());

      return true;
    }

    return false;
  }


  void MButton::setCaption(const std::string &caption) {
    m_Caption = caption;

    if (m_Handle != 0l) {
      // TODO: Cache the casted pointer, or so..
      QPushButton* but = dynamic_cast<QPushButton*>(m_Handle);
      but->setText(caption.c_str());
    }

    minButSize = MSize2D(-1,-1);
    // TODO: tell the container that we may have changed size.
  }

  std::string MButton::getCaption() {
    return m_Caption;
  }

  void MButton::setCommand(const std::string &command) {
    m_Command = command;
  }

  std::string MButton::getCommand() {
    return m_Command;
  }

  bool MButton::onClick() {
    return false;
  }

  void MButton::setButtonDown(bool buttonDown) {
    // Casting is fun..
    QPushButton* but = dynamic_cast<QPushButton*>(m_Handle);
    if (but != 0l) but->setOn(buttonDown);
  }

  bool MButton::getButtonDown() {
    // Casting is boring..
    QPushButton* but = dynamic_cast<QPushButton*>(m_Handle);
    return (but->state() == QButton::On);
  }

  void MButton::setImage(const Aztec::MImagePtr& i) {
    // TODO: Implementation
  }

  void MButton::addListener(const MButtonListenerPtr &listener) {
//    listeners.push_back(listener);
  }

  MSize2D MButton::getMinimumSize() {
    MSize2D size = MComponent::getMinimumSize();
    updateMinButSize();

    return MSize2D(size.getWidth() < minButSize.getWidth() ? minButSize.getWidth() : size.getWidth(),
                   size.getHeight() < minButSize.getHeight() ? minButSize.getHeight() : size.getHeight());
  }

  bool MButton::isMinimumSizeSet() {
    return true;
  }

  void MButton::updateMinButSize() {
    if (minButSize.getWidth() == -1 || minButSize.getHeight() == -1) {
      /*QFontMetrics fm = m_Handle->fontMetrics();

      // TODO: Check (0 < blah)
      QRect rc = fm.boundingRect(m_Caption.c_str());
      minButSize.setWidth(rc.width()+24);
      minButSize.setHeight(rc.height()+14);*/

//      if (m_Handle == 0l) return;
      minButSize.setWidth(m_Handle->width()-2);
      minButSize.setHeight(m_Handle->height()-2);
    }
  }


}

