/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <AztecGUICommonPCH.h>
#include <gui/MContainer.h>

#include <gui/qt3/MAppImpl.h>
#include <gui/qt3/MContainerImpl.h>

#include <algorithm>
#include <iostream>

#include <gui/qt3/QContainer_.moc>


using Aztec::MContainerPtr;
using Aztec::MComponentPtr;
using Aztec::MConstraint;
using Aztec::MLayoutManagerPtr;
using Aztec::MPoint2D;


namespace Aztec {

  MContainer::MContainer() {
  }

  MContainer::MContainer(const std::string &name) {
  }

  MContainer::MContainer(MContainerPtr parent) {
  }

  MContainer::MContainer(const std::string &name, MContainerPtr *parent) {
  }

  MContainer::MContainer(int X, int Y, int width, int height) {
  }

  MContainer::~MContainer() {
  }

  bool MContainer::createImpl() {
    MApp* app = MApp::getInstance();

    // Only create the window once
    if (m_Handle != 0l) {
      return true;
    }

    QWidget* parentWnd = 0l;
    if (m_Parent != 0l) {
      parentWnd = m_Parent->getHandle();
    }

    m_Handle = new CQContainer_(parentWnd, this);

    if (m_Handle != 0l) {
      app->registerComponent(m_Handle, this);

      onCreate();

      // Do NOT outcomment this visibility call,
      // It makes other windows flash (you'll understand
      // why when seeing this in action)
      //setVisible(true);

      //m_Handle->update();

      return true;
    }

    return false;
  }

  int MContainer::getComponentCount() {
    return m_Children.size();
  }

  MComponentPtr MContainer::getComponent(int index) {
    if (index < 0 || index >= m_Children.size()) {
      return NULL;
    }

    return m_Children[index];
  }

  void MContainer::addComponent(MComponentPtr component) {
    addComponent(component, MConstraint());
  }

  void MContainer::addComponent(MComponentPtr component, int index) {
    addComponent(component, index, MConstraint());
  }

  void MContainer::addComponent(MComponentPtr component, MConstraint constraints) {
    if (getComponentIndex(component) != -1) {
      return;
    }

    m_Children.push_back(component);

    // add it to the layout manager if appropriate.
    if (m_LayoutManager != NULL) {
      m_LayoutManager->addComponent(component, constraints);
    }

    // set the parent.
    if (component->getParent() != this) {
      component->setParent(this);
    }

    doLayout();
  }

  void MContainer::addComponent(MComponentPtr component, int index, MConstraint constraints) {
    if (getComponentIndex(component) != -1) {
      return;
    }

    // clamp the index to be 0 or greater
    if (index < 0) {
      index = 0;
    }

    // clamp the index so it is the number of children or less.
    if (index > m_Children.size()) {
      index = m_Children.size();
    }

    // insert the child.
    m_Children.insert(m_Children.begin() + index);

    // add it to the layout manager if appropriate.
    if (m_LayoutManager != NULL) {
      m_LayoutManager->addComponent(component, constraints);
    }

    // set the parent.
    if (component->getParent() != this) {
      component->setParent(this);
    }

    doLayout();
  }


  void MContainer::removeComponent(int index) {
    if (index < 0 || index >= m_Children.size()) {
      return;
    }

    MComponentPtr comp;

    comp = m_Children[index];

    m_Children.erase(m_Children.begin() + index);

    comp->setParent(NULL);
  }

  void MContainer::removeComponent(MComponentPtr component) {
    int index = getComponentIndex(component);;

    // if the component was be found, remove it.
    if (index != -1) {
      removeComponent(index);
    }

  }

  int MContainer::getComponentIndex(MComponentPtr component) {
    for (int index = 0; index < m_Children.size(); ++index) {
      if (m_Children[index] == component) {
        return index;
      }
    }

    return -1;
  }


  void MContainer::setLayoutManager(MLayoutManagerPtr layout) {
    m_LayoutManager = layout;

    if (m_LayoutManager != NULL) {
      // add all the current components to the layout manager
      for (int n = 0;n < m_Children.size(); ++n) {
        m_LayoutManager->addComponent(m_Children[n]);
      }
    }
  }

  MLayoutManagerPtr MContainer::getLayoutManager() {
    return m_LayoutManager;
  }

  void MContainer::doLayout() {
    if (m_LayoutManager != NULL) {
      m_LayoutManager->layoutContainer(this);
    }
  }

  bool MContainer::onCommand(const std::string &command, const MComponentPtr &component) {
    return false;
  }

  MSize2D MContainer::getClientSize() {
    return MComponent::getClientSize();
  }

  MSize2D MContainer::getMinimumSize() {
    MSize2D min = MComponent::getMinimumSize();

    if (m_LayoutManager != NULL) {
      MSize2D layoutSize = m_LayoutManager->getMinimumSize(this);

      min.setWidth(min.getWidth() > layoutSize.getWidth() ? min.getWidth() : layoutSize.getWidth());
      min.setHeight(min.getHeight() > layoutSize.getHeight() ? min.getHeight() : layoutSize.getHeight());
    }

    return min;
  }

  MSize2D MContainer::getPreferredSize() {
    MSize2D pref = MComponent::getPreferredSize();

    if (m_LayoutManager != NULL) {
      MSize2D layoutSize = m_LayoutManager->getPreferredSize(this);

      pref.setWidth(pref.getWidth() > layoutSize.getWidth() ? pref.getWidth() : layoutSize.getWidth());
      pref.setHeight(pref.getHeight() > layoutSize.getHeight() ? pref.getHeight() : layoutSize.getHeight());
    }

    return pref;
  }

  void MContainer::refresh() {
    // invalidate all the child components
    for (int i = 0; i < m_Children.size(); ++i) {
      m_Children[i]->refresh();
    }

    MComponent::refresh();
  }

  bool MContainer::onResize(int newWidth, int newHeight) {
    MComponent::onResize(newWidth, newHeight);

    doLayout();

    return true;
  }

  bool MContainer::onShow() {
    MComponent::onShow();

    //////// UGLY HACK /////////
    // TODO: Remove? (please.. :)
    //       btw. toolkits on Linux do not display things correctly
    //       when doing things like this so it's only useful for debugging.
    //       Filling rectangles makes things too slow (XFree86 is too old).
    #warning TODO: Remove debugging code
    if (m_Handle && bgColourSet)
      m_Handle->setEraseColor(QColor(bgColour.getRuchar(), bgColour.getGuchar(), bgColour.getBuchar()));
    //////// UGLY HACK /////////

    doLayout();

    return true;
  }

}

