/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <AztecGUICommonPCH.h>
#include <gui/MGLCanvas.h>

#include <gui/qt3/MAppImpl.h>
#include <gui/qt3/MGLCanvasImpl.h>

#include <MSystemManager.h>
#include <iostream>

#include <gui/qt3/QGLCanvas_.moc>


namespace Aztec {

  MGLCanvas::MGLCanvas() {
  }

  MGLCanvas::~MGLCanvas() {
    killOpenGL();
  }

  MGLCanvas::GLErrorEnum MGLCanvas::initOpenGL() {

    // make that the pixel format of the device context 
/*    MSystemManager::getInstance()->logOutput("OpenGLWnd::InitOpenGL() - Pixel Format %ibpp, %iAlpha bits, %iZBuf", pfd.cColorBits, pfd.cAlphaBits, pfd.cDepthBits);*/
    

    glShadeModel(GL_SMOOTH);
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_CULL_FACE);
    glEnable(GL_NORMALIZE);
    glCullFace(GL_BACK);
    
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
    
    glShadeModel(GL_SMOOTH);
    glEnable(GL_LIGHT0);

    return GL_OK;
  }

  MGLCanvas::GLErrorEnum MGLCanvas::killOpenGL() {
    // Make the current context not null.
/*    wglMakeCurrent(NULL, NULL);
    wglDeleteContext(glContext);
    glContext = NULL;*/
    
    return GL_OK;
  }


  // IMGLCanvas methods

  MGLCanvas::GLErrorEnum MGLCanvas::makeCurrent() {
    QGLWidget* glw = dynamic_cast<QGLWidget*>(m_Handle);
    if (glw != 0l) {
      glw->makeCurrent();
      glViewport(0, 0, m_newx, m_newy);
    }
  }

  bool MGLCanvas::swapBuffers() {
    QGLWidget* glw = dynamic_cast<QGLWidget*>(m_Handle);
    if (glw != 0l) {
      glw->makeCurrent();
      glw->swapBuffers();
    }
  }

  bool MGLCanvas::createImpl() {
    MApp* app;
    QWidget* parentWnd = 0l;

    // Get the parent widget handle, so we can create our button
    if (m_Parent != 0l) {
      parentWnd = m_Parent->getHandle();
    }

    app = MApp::getInstance();

    // create the actual widget
    m_Handle = new CQGLCanvas_(parentWnd, this);

    // if it succeeded, update everything
    if (m_Handle != 0) {
      // Register this widget with the application
      app->registerComponent(m_Handle, this);

      // Call the create event handler
      //onCreate();

      // Do NOT outcomment this visibility call,
      // It makes other windows flash (you'll understand
      // why when seeing this in action)
      //setVisible(true);

      /*::UpdateWindow(m_hWnd);*/

      return true;
    }

/*    bool result = MComponent::createImpl();*/

    initOpenGL();

    return true; //result;
  }

  bool MGLCanvas::onResize(int newWidth, int newHeight) {
    m_newx = newWidth;
    m_newy = newHeight;

    MComponent::onResize(newWidth, newHeight);

    //makeCurrent();
    //glViewport(0, 0, newWidth, newHeight);

    return true;
  }

  bool MGLCanvas::onPaint() {
//    bool result = MComponent::onPaint();

    QGLWidget* glw = dynamic_cast<QGLWidget*>(m_Handle);
    if (glw != 0l) glw->makeCurrent();

    return true;

  }

}

