/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <AztecGUICommonPCH.h>

#include <gui/qt3/MWindowImpl.h>
#include <gui/qt3/MAppImpl.h>
//#include <gui/qt3/MMenuImpl.h>

#include <iostream>

#include <gui/qt3/QWindow_.moc>


namespace Aztec {

  MWindow::MWindow(const std::string &title) {
    setTitle(title);
  }

  MWindow::~MWindow() {
  }

  bool MWindow::createImpl() {
    MApp* app = MApp::getInstance();

    // Only create the window once
    if (m_Handle != 0l) {
      std::cout << "already registered: " << m_Title << std::endl;
      return true;
    }

    QWidget* parentWnd = 0l;
    if (m_Parent != 0l) m_Parent->getHandle();

    //m_Handle = new QMainWindow(0, m_Title.c_str());
    m_Handle = new CQWindow_(parentWnd, this);

    if (m_Handle != 0l) {
      app->registerComponent(m_Handle, this);

      onCreate();

      //setVisible(true);
      //::UpdateWindow(m_hWnd);
      //m_Handle->update();
      m_Handle->setCaption(m_Title.c_str());

      return true;
    }

    return false;
  }

  bool MWindow::create() {
    return createImpl();
  }

  void MWindow::setTitle(const std::string &title) {
    m_Title = title;

   if (m_Handle != 0l) {
     m_Handle->setCaption(m_Title.c_str());
   }

  }

  std::string MWindow::getTitle() {
    return m_Title;
  }

  void MWindow::setMenu(MMenuPtr menu) {
/*    if (menu == NULL) {
      m_Menu = NULL;
      ::SetMenu(m_hWnd, NULL);
    } else {
      m_Menu = menu;
      ::SetMenu(m_hWnd, menu->getHMenu(false));
    }

    // after setting a menu, we have to do a layout, because the client area may have changed.
    doLayout();*/
  }

  MMenuPtr MWindow::getMenu() {
//    return m_Menu;
  }

  void MWindow::close() {
    // TODO: Implementation
    //::SendMessage(m_hWnd, WM_CLOSE, 0, 0);
  }

  bool MWindow::onClose() {
    return false;
  }

}

