#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MKeyEvent.h>

namespace Aztec {



  static JSBool js_MKeyEvent_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    
    return JS_SetPrivate(cx, obj, NULL);
  }
  
  static void js_MKeyEvent_finalize(JSContext *cx, JSObject *obj) {
    MKeyEvent *event = reinterpret_cast<MKeyEvent*>(JS_GetPrivate(cx, obj));

    if (event != NULL) {
      delete event;
    }

    JS_SetPrivate(cx, obj, NULL);

  }
  
  static JSBool js_getType(JSContext *cx, JSObject *obj, jsval id, jsval *rval) {
    MKeyEvent *event = reinterpret_cast<MKeyEvent*>(JS_GetPrivate(cx, obj));

    if (event != NULL) {
      *rval = INT_TO_JSVAL(event->getType());
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }


  static JSBool js_getCode(JSContext *cx, JSObject *obj, jsval id, jsval *rval) {
    MKeyEvent *event = reinterpret_cast<MKeyEvent*>(JS_GetPrivate(cx, obj));

    if (event != NULL) {
      *rval = INT_TO_JSVAL(event->getCode());
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }

  static JSBool js_getChar(JSContext *cx, JSObject *obj, jsval id, jsval *rval) {
    MKeyEvent *event = reinterpret_cast<MKeyEvent*>(JS_GetPrivate(cx, obj));

    if (event != NULL) {
      char buf[2];
      buf[0] = event->getChar();
      buf[1] = '\0';
      *rval = STRING_TO_JSVAL( JS_NewStringCopyZ(cx, buf) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }

  static JSBool js_static_keyCodeToStr(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    if (argc != 1) {
      return JS_FALSE;
    }

    int32 code = -1;
    if (!JS_ValueToInt32(cx, argv[0], &code)) {
      return JS_FALSE;
    }

    MKeyEvent *event = reinterpret_cast<MKeyEvent*>(JS_GetPrivate(cx, obj));

    if (event != NULL) {
      *rval = STRING_TO_JSVAL( JS_NewStringCopyZ(cx, MKeyEvent::keyCodeToStr((MKeyEvent::KeyCode)code).c_str()) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }

  static JSBool js_static_strToKeyCode(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    if (argc != 1) {
      return JS_FALSE;
    }

    MKeyEvent *event = reinterpret_cast<MKeyEvent*>(JS_GetPrivate(cx, obj));

    if (event != NULL) {
      *rval = JSVAL_TO_INT( MKeyEvent::strToKeyCode(JS_GetStringBytes(JS_ValueToString(cx, argv[0]))) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }

  
  JSClass js_MKeyEvent_class = {
    "MKeyEvent", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   js_MKeyEvent_finalize
  };
  
  JSFunctionSpec js_MKeyEvent_methods[] = {
    {NULL,                NULL,                   0} 
  };

  JSPropertySpec aztecMKeyEvent_props[] = {
    {"code", 0, JSPROP_ENUMERATE | JSPROP_READONLY, js_getCode }, 
    {"ascii", 1, JSPROP_ENUMERATE | JSPROP_READONLY, js_getChar },
    {"type", 1, JSPROP_ENUMERATE | JSPROP_READONLY, js_getType },
    {0, 0, 0, 0}
  };
  

  static void addProperty(JSContext *cx, JSObject *con, const char *name, int value) {
    JS_DefineProperty(cx, con, name, INT_TO_JSVAL(value), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
  }

  JSObject* initMKeyEventClass(JSContext *cx) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), NULL,
      &js_MKeyEvent_class, js_MKeyEvent_constructor, 0,
      NULL, js_MKeyEvent_methods, 0, 0);

    JSObject *con = JS_GetConstructor(cx, cl);

    if (con != NULL) {

      JS_DefineFunction(cx, con, "keyCodeToStr", js_static_keyCodeToStr, 1, 0);
      JS_DefineFunction(cx, con, "strToKeyCode", js_static_strToKeyCode, 1, 0);

      addProperty(cx, con, "Key_Unknown", MKeyEvent::Key_Unknown);
      addProperty(cx, con, "Key_LeftButton", MKeyEvent::Key_LeftButton);
      addProperty(cx, con, "Key_RightButton", MKeyEvent::Key_RightButton);
      addProperty(cx, con, "Key_MiddleButton", MKeyEvent::Key_MiddleButton);
      addProperty(cx, con, "Key_Escape", MKeyEvent::Key_Escape);
      addProperty(cx, con, "Key_Tab", MKeyEvent::Key_Tab);
      addProperty(cx, con, "Key_Backtab", MKeyEvent::Key_Backtab);
      addProperty(cx, con, "Key_Backspace", MKeyEvent::Key_Backspace);
      addProperty(cx, con, "Key_Return", MKeyEvent::Key_Return);
      addProperty(cx, con, "Key_Insert", MKeyEvent::Key_Insert);
      addProperty(cx, con, "Key_Delete", MKeyEvent::Key_Delete);
      addProperty(cx, con, "Key_Pause", MKeyEvent::Key_Pause);
      addProperty(cx, con, "Key_Print", MKeyEvent::Key_Print);
      addProperty(cx, con, "Key_SysReq", MKeyEvent::Key_SysReq);
      addProperty(cx, con, "Key_Home", MKeyEvent::Key_Home);
      addProperty(cx, con, "Key_End", MKeyEvent::Key_End);
      addProperty(cx, con, "Key_Left", MKeyEvent::Key_Left);
      addProperty(cx, con, "Key_Up", MKeyEvent::Key_Up);
      addProperty(cx, con, "Key_Right", MKeyEvent::Key_Right);
      addProperty(cx, con, "Key_Down", MKeyEvent::Key_Down);
      addProperty(cx, con, "Key_Prior", MKeyEvent::Key_Prior);
      addProperty(cx, con, "Key_Next", MKeyEvent::Key_Next);
      addProperty(cx, con, "Key_Shift", MKeyEvent::Key_Shift);
      addProperty(cx, con, "Key_Control", MKeyEvent::Key_Control);
      addProperty(cx, con, "Key_Meta", MKeyEvent::Key_Meta);
      addProperty(cx, con, "Key_Alt", MKeyEvent::Key_Alt);
      addProperty(cx, con, "Key_CapsLock", MKeyEvent::Key_CapsLock);
      addProperty(cx, con, "Key_NumLock", MKeyEvent::Key_NumLock);
      addProperty(cx, con, "Key_ScrollLock", MKeyEvent::Key_ScrollLock);
      addProperty(cx, con, "Key_Clear", MKeyEvent::Key_Clear);
      addProperty(cx, con, "Key_F1", MKeyEvent::Key_F1);
      addProperty(cx, con, "Key_F2", MKeyEvent::Key_F2);
      addProperty(cx, con, "Key_F3", MKeyEvent::Key_F3);
      addProperty(cx, con, "Key_F4", MKeyEvent::Key_F4);
      addProperty(cx, con, "Key_F5", MKeyEvent::Key_F5);
      addProperty(cx, con, "Key_F6", MKeyEvent::Key_F6);
      addProperty(cx, con, "Key_F7", MKeyEvent::Key_F7);
      addProperty(cx, con, "Key_F8", MKeyEvent::Key_F8);
      addProperty(cx, con, "Key_F9", MKeyEvent::Key_F9);
      addProperty(cx, con, "Key_F10", MKeyEvent::Key_F10);
      addProperty(cx, con, "Key_F11", MKeyEvent::Key_F11);
      addProperty(cx, con, "Key_F12", MKeyEvent::Key_F12);
      addProperty(cx, con, "Key_F13", MKeyEvent::Key_F13);
      addProperty(cx, con, "Key_F14", MKeyEvent::Key_F14);
      addProperty(cx, con, "Key_F15", MKeyEvent::Key_F15);
      addProperty(cx, con, "Key_F16", MKeyEvent::Key_F16);
      addProperty(cx, con, "Key_F17", MKeyEvent::Key_F17);
      addProperty(cx, con, "Key_F18", MKeyEvent::Key_F18);
      addProperty(cx, con, "Key_F19", MKeyEvent::Key_F19);
      addProperty(cx, con, "Key_F20", MKeyEvent::Key_F20);
      addProperty(cx, con, "Key_F21", MKeyEvent::Key_F21);
      addProperty(cx, con, "Key_F22", MKeyEvent::Key_F22);
      addProperty(cx, con, "Key_F23", MKeyEvent::Key_F23);
      addProperty(cx, con, "Key_F24", MKeyEvent::Key_F24);
      addProperty(cx, con, "Key_F25", MKeyEvent::Key_F25);
      addProperty(cx, con, "Key_F26", MKeyEvent::Key_F26);
      addProperty(cx, con, "Key_F27", MKeyEvent::Key_F27);
      addProperty(cx, con, "Key_F28", MKeyEvent::Key_F28);
      addProperty(cx, con, "Key_F29", MKeyEvent::Key_F29);
      addProperty(cx, con, "Key_F30", MKeyEvent::Key_F30);
      addProperty(cx, con, "Key_F31", MKeyEvent::Key_F31);
      addProperty(cx, con, "Key_F32", MKeyEvent::Key_F32);
      addProperty(cx, con, "Key_F33", MKeyEvent::Key_F33);
      addProperty(cx, con, "Key_F34", MKeyEvent::Key_F34);
      addProperty(cx, con, "Key_F35", MKeyEvent::Key_F35);
      addProperty(cx, con, "Key_Menu", MKeyEvent::Key_Menu);
      addProperty(cx, con, "Key_Help", MKeyEvent::Key_Help);
      addProperty(cx, con, "Key_Space", MKeyEvent::Key_Space);
      addProperty(cx, con, "Key_Any", MKeyEvent::Key_Any);
      addProperty(cx, con, "Key_QuoteDbl", MKeyEvent::Key_QuoteDbl);
      addProperty(cx, con, "Key_NumberSign", MKeyEvent::Key_NumberSign);
      addProperty(cx, con, "Key_Dollar", MKeyEvent::Key_Dollar);
      addProperty(cx, con, "Key_Percent", MKeyEvent::Key_Percent);
      addProperty(cx, con, "Key_Ampersand", MKeyEvent::Key_Ampersand);
      addProperty(cx, con, "Key_Apostrophe", MKeyEvent::Key_Apostrophe);
      addProperty(cx, con, "Key_ParenLeft", MKeyEvent::Key_ParenLeft);
      addProperty(cx, con, "Key_ParenRight", MKeyEvent::Key_ParenRight);
      addProperty(cx, con, "Key_Asterisk", MKeyEvent::Key_Asterisk);
      addProperty(cx, con, "Key_Plus", MKeyEvent::Key_Plus);
      addProperty(cx, con, "Key_Comma", MKeyEvent::Key_Comma);
      addProperty(cx, con, "Key_Minus", MKeyEvent::Key_Minus);
      addProperty(cx, con, "Key_Period", MKeyEvent::Key_Period);
      addProperty(cx, con, "Key_Slash", MKeyEvent::Key_Slash);
      addProperty(cx, con, "Key_0", MKeyEvent::Key_0);
      addProperty(cx, con, "Key_1", MKeyEvent::Key_1);
      addProperty(cx, con, "Key_2", MKeyEvent::Key_2);
      addProperty(cx, con, "Key_3", MKeyEvent::Key_3);
      addProperty(cx, con, "Key_4", MKeyEvent::Key_4);
      addProperty(cx, con, "Key_5", MKeyEvent::Key_5);
      addProperty(cx, con, "Key_6", MKeyEvent::Key_6);
      addProperty(cx, con, "Key_7", MKeyEvent::Key_7);
      addProperty(cx, con, "Key_8", MKeyEvent::Key_8);
      addProperty(cx, con, "Key_9", MKeyEvent::Key_9);
      addProperty(cx, con, "Key_Colon", MKeyEvent::Key_Colon);
      addProperty(cx, con, "Key_Semicolon", MKeyEvent::Key_Semicolon);
      addProperty(cx, con, "Key_Less", MKeyEvent::Key_Less);
      addProperty(cx, con, "Key_Equal", MKeyEvent::Key_Equal);
      addProperty(cx, con, "Key_Greater", MKeyEvent::Key_Greater);
      addProperty(cx, con, "Key_Question", MKeyEvent::Key_Question);
      addProperty(cx, con, "Key_At", MKeyEvent::Key_At);
      addProperty(cx, con, "Key_A", MKeyEvent::Key_A);
      addProperty(cx, con, "Key_B", MKeyEvent::Key_B);
      addProperty(cx, con, "Key_C", MKeyEvent::Key_C);
      addProperty(cx, con, "Key_D", MKeyEvent::Key_D);
      addProperty(cx, con, "Key_E", MKeyEvent::Key_E);
      addProperty(cx, con, "Key_F", MKeyEvent::Key_F);
      addProperty(cx, con, "Key_G", MKeyEvent::Key_G);
      addProperty(cx, con, "Key_H", MKeyEvent::Key_H);
      addProperty(cx, con, "Key_I", MKeyEvent::Key_I);
      addProperty(cx, con, "Key_J", MKeyEvent::Key_J);
      addProperty(cx, con, "Key_K", MKeyEvent::Key_K);
      addProperty(cx, con, "Key_L", MKeyEvent::Key_L);
      addProperty(cx, con, "Key_M", MKeyEvent::Key_M);
      addProperty(cx, con, "Key_N", MKeyEvent::Key_N);
      addProperty(cx, con, "Key_O", MKeyEvent::Key_O);
      addProperty(cx, con, "Key_P", MKeyEvent::Key_P);
      addProperty(cx, con, "Key_Q", MKeyEvent::Key_Q);
      addProperty(cx, con, "Key_R", MKeyEvent::Key_R);
      addProperty(cx, con, "Key_S", MKeyEvent::Key_S);
      addProperty(cx, con, "Key_T", MKeyEvent::Key_T);
      addProperty(cx, con, "Key_U", MKeyEvent::Key_U);
      addProperty(cx, con, "Key_V", MKeyEvent::Key_V);
      addProperty(cx, con, "Key_W", MKeyEvent::Key_W);
      addProperty(cx, con, "Key_X", MKeyEvent::Key_X);
      addProperty(cx, con, "Key_Y", MKeyEvent::Key_Y);
      addProperty(cx, con, "Key_Z", MKeyEvent::Key_Z);
      addProperty(cx, con, "Key_BracketLeft", MKeyEvent::Key_BracketLeft);
      addProperty(cx, con, "Key_Backslash", MKeyEvent::Key_Backslash);
      addProperty(cx, con, "Key_BracketRight", MKeyEvent::Key_BracketRight);
      addProperty(cx, con, "Key_AsciiCircum", MKeyEvent::Key_AsciiCircum);
      addProperty(cx, con, "Key_Underscore", MKeyEvent::Key_Underscore);
      addProperty(cx, con, "Key_QuoteLeft", MKeyEvent::Key_QuoteLeft);
      addProperty(cx, con, "Key_BraceLeft", MKeyEvent::Key_BraceLeft);
      addProperty(cx, con, "Key_Bar", MKeyEvent::Key_Bar);
      addProperty(cx, con, "Key_BraceRight", MKeyEvent::Key_BraceRight);
      addProperty(cx, con, "Key_AsciiTilde", MKeyEvent::Key_AsciiTilde);
      addProperty(cx, con, "Key_nobreakspace", MKeyEvent::Key_nobreakspace);
      addProperty(cx, con, "Key_exclamdown", MKeyEvent::Key_exclamdown);
      addProperty(cx, con, "Key_cent", MKeyEvent::Key_cent);
      addProperty(cx, con, "Key_sterling", MKeyEvent::Key_sterling);
      addProperty(cx, con, "Key_currency", MKeyEvent::Key_currency);
      addProperty(cx, con, "Key_yen", MKeyEvent::Key_yen);
      addProperty(cx, con, "Key_brokenbar", MKeyEvent::Key_brokenbar);
      addProperty(cx, con, "Key_section", MKeyEvent::Key_section);
      addProperty(cx, con, "Key_diaeresis", MKeyEvent::Key_diaeresis);
      addProperty(cx, con, "Key_copyright", MKeyEvent::Key_copyright);
      addProperty(cx, con, "Key_ordfeminine", MKeyEvent::Key_ordfeminine);
      addProperty(cx, con, "Key_guillemotleft", MKeyEvent::Key_guillemotleft);
      addProperty(cx, con, "Key_notsign", MKeyEvent::Key_notsign);
      addProperty(cx, con, "Key_hyphen", MKeyEvent::Key_hyphen);
      addProperty(cx, con, "Key_registered", MKeyEvent::Key_registered);
      addProperty(cx, con, "Key_macron", MKeyEvent::Key_macron);
      addProperty(cx, con, "Key_degree", MKeyEvent::Key_degree);
      addProperty(cx, con, "Key_plusminus", MKeyEvent::Key_plusminus);
      addProperty(cx, con, "Key_twosuperior", MKeyEvent::Key_twosuperior);
      addProperty(cx, con, "Key_threesuperior", MKeyEvent::Key_threesuperior);
      addProperty(cx, con, "Key_acute", MKeyEvent::Key_acute);
      addProperty(cx, con, "Key_mu", MKeyEvent::Key_mu);
      addProperty(cx, con, "Key_paragraph", MKeyEvent::Key_paragraph);
      addProperty(cx, con, "Key_periodcentered", MKeyEvent::Key_periodcentered);
      addProperty(cx, con, "Key_cedilla", MKeyEvent::Key_cedilla);
      addProperty(cx, con, "Key_onesuperior", MKeyEvent::Key_onesuperior);
      addProperty(cx, con, "Key_masculine", MKeyEvent::Key_masculine);
      addProperty(cx, con, "Key_guillemotright", MKeyEvent::Key_guillemotright);
      addProperty(cx, con, "Key_onequarter", MKeyEvent::Key_onequarter);
      addProperty(cx, con, "Key_onehalf", MKeyEvent::Key_onehalf);
      addProperty(cx, con, "Key_threequarters", MKeyEvent::Key_threequarters);
      addProperty(cx, con, "Key_questiondown", MKeyEvent::Key_questiondown);
      addProperty(cx, con, "Key_Agrave", MKeyEvent::Key_Agrave);
      addProperty(cx, con, "Key_Aacute", MKeyEvent::Key_Aacute);
      addProperty(cx, con, "Key_Acircumflex", MKeyEvent::Key_Acircumflex);
      addProperty(cx, con, "Key_Atilde", MKeyEvent::Key_Atilde);
      addProperty(cx, con, "Key_Adiaeresis", MKeyEvent::Key_Adiaeresis);
      addProperty(cx, con, "Key_Aring", MKeyEvent::Key_Aring);
      addProperty(cx, con, "Key_AE", MKeyEvent::Key_AE);
      addProperty(cx, con, "Key_Ccedilla", MKeyEvent::Key_Ccedilla);
      addProperty(cx, con, "Key_Egrave", MKeyEvent::Key_Egrave);
      addProperty(cx, con, "Key_Eacute", MKeyEvent::Key_Eacute);
      addProperty(cx, con, "Key_Ecircumflex", MKeyEvent::Key_Ecircumflex);
      addProperty(cx, con, "Key_Ediaeresis", MKeyEvent::Key_Ediaeresis);
      addProperty(cx, con, "Key_Igrave", MKeyEvent::Key_Igrave);
      addProperty(cx, con, "Key_Iacute", MKeyEvent::Key_Iacute);
      addProperty(cx, con, "Key_Icircumflex", MKeyEvent::Key_Icircumflex);
      addProperty(cx, con, "Key_Idiaeresis", MKeyEvent::Key_Idiaeresis);
      addProperty(cx, con, "Key_ETH", MKeyEvent::Key_ETH);
      addProperty(cx, con, "Key_Ntilde", MKeyEvent::Key_Ntilde);
      addProperty(cx, con, "Key_Ograve", MKeyEvent::Key_Ograve);
      addProperty(cx, con, "Key_Oacute", MKeyEvent::Key_Oacute);
      addProperty(cx, con, "Key_Ocircumflex", MKeyEvent::Key_Ocircumflex);
      addProperty(cx, con, "Key_Otilde", MKeyEvent::Key_Otilde);
      addProperty(cx, con, "Key_Odiaeresis", MKeyEvent::Key_Odiaeresis);
      addProperty(cx, con, "Key_multiply", MKeyEvent::Key_multiply);
      addProperty(cx, con, "Key_Ooblique", MKeyEvent::Key_Ooblique);
      addProperty(cx, con, "Key_Ugrave", MKeyEvent::Key_Ugrave);
      addProperty(cx, con, "Key_Uacute", MKeyEvent::Key_Uacute);
      addProperty(cx, con, "Key_Ucircumflex", MKeyEvent::Key_Ucircumflex);
      addProperty(cx, con, "Key_Udiaeresis", MKeyEvent::Key_Udiaeresis);
      addProperty(cx, con, "Key_Yacute", MKeyEvent::Key_Yacute);
      addProperty(cx, con, "Key_THORN", MKeyEvent::Key_THORN);
      addProperty(cx, con, "Key_ssharp", MKeyEvent::Key_ssharp);
      addProperty(cx, con, "Key_agrave", MKeyEvent::Key_agrave);
      addProperty(cx, con, "Key_aacute", MKeyEvent::Key_aacute);
      addProperty(cx, con, "Key_acircumflex", MKeyEvent::Key_acircumflex);
      addProperty(cx, con, "Key_atilde", MKeyEvent::Key_atilde);
      addProperty(cx, con, "Key_adiaeresis", MKeyEvent::Key_adiaeresis);
      addProperty(cx, con, "Key_aring", MKeyEvent::Key_aring);
      addProperty(cx, con, "Key_ae", MKeyEvent::Key_ae);
      addProperty(cx, con, "Key_ccedilla", MKeyEvent::Key_ccedilla);
      addProperty(cx, con, "Key_egrave", MKeyEvent::Key_egrave);
      addProperty(cx, con, "Key_eacute", MKeyEvent::Key_eacute);
      addProperty(cx, con, "Key_ecircumflex", MKeyEvent::Key_ecircumflex);
      addProperty(cx, con, "Key_ediaeresis", MKeyEvent::Key_ediaeresis);
      addProperty(cx, con, "Key_igrave", MKeyEvent::Key_igrave);
      addProperty(cx, con, "Key_iacute", MKeyEvent::Key_iacute);
      addProperty(cx, con, "Key_icircumflex", MKeyEvent::Key_icircumflex);
      addProperty(cx, con, "Key_idiaeresis", MKeyEvent::Key_idiaeresis);
      addProperty(cx, con, "Key_eth", MKeyEvent::Key_eth);
      addProperty(cx, con, "Key_ntilde", MKeyEvent::Key_ntilde);
      addProperty(cx, con, "Key_ograve", MKeyEvent::Key_ograve);
      addProperty(cx, con, "Key_oacute", MKeyEvent::Key_oacute);
      addProperty(cx, con, "Key_ocircumflex", MKeyEvent::Key_ocircumflex);
      addProperty(cx, con, "Key_otilde", MKeyEvent::Key_otilde);
      addProperty(cx, con, "Key_odiaeresis", MKeyEvent::Key_odiaeresis);
      addProperty(cx, con, "Key_division", MKeyEvent::Key_division);
      addProperty(cx, con, "Key_oslash", MKeyEvent::Key_oslash);
      addProperty(cx, con, "Key_ugrave", MKeyEvent::Key_ugrave);
      addProperty(cx, con, "Key_uacute", MKeyEvent::Key_uacute);
      addProperty(cx, con, "Key_ucircumflex", MKeyEvent::Key_ucircumflex);
      addProperty(cx, con, "Key_udiaeresis", MKeyEvent::Key_udiaeresis);
      addProperty(cx, con, "Key_yacute", MKeyEvent::Key_yacute);
      addProperty(cx, con, "Key_thorn", MKeyEvent::Key_thorn);
      addProperty(cx, con, "Key_ydiaeresis", MKeyEvent::Key_ydiaeresis);
    
    }

    return cl;
  }

  JSObject* createKeyEvent(JSContext *cx, JSObject *parent, const MKeyEvent &event) {
    JSObject *object = JS_NewObject(cx, &js_MKeyEvent_class, NULL, parent);
    JS_DefineProperties(cx, object, aztecMKeyEvent_props);
    JS_SetPrivate(cx, object, new MKeyEvent(event)) ;
    return object;
  }

}
