#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MMouseEvent.h>

namespace Aztec {



  static JSBool js_MMouseEvent_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    
    return JS_SetPrivate(cx, obj, NULL);
  }
  
  static void js_MMouseEvent_finalize(JSContext *cx, JSObject *obj) {
    MMouseEvent *event = reinterpret_cast<MMouseEvent*>(JS_GetPrivate(cx, obj));

    if (event != NULL) {
      delete event;
    }

    JS_SetPrivate(cx, obj, NULL);

  }
  
  static JSBool js_getX(JSContext *cx, JSObject *obj, jsval id, jsval *rval) {
    MMouseEvent *event = reinterpret_cast<MMouseEvent*>(JS_GetPrivate(cx, obj));

    if (event != NULL) {
      *rval = INT_TO_JSVAL(event->getX());
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }

  static JSBool js_getY(JSContext *cx, JSObject *obj, jsval id, jsval *rval) {
    MMouseEvent *event = reinterpret_cast<MMouseEvent*>(JS_GetPrivate(cx, obj));

    if (event != NULL) {
      *rval = INT_TO_JSVAL(event->getY());
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }

  static JSBool js_getType(JSContext *cx, JSObject *obj, jsval id, jsval *rval) {
    MMouseEvent *event = reinterpret_cast<MMouseEvent*>(JS_GetPrivate(cx, obj));

    if (event != NULL) {
      *rval = INT_TO_JSVAL(event->getType());
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }

  
  JSClass js_MMouseEvent_class = {
    "MMouseEvent", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   js_MMouseEvent_finalize
  };
  
  JSFunctionSpec js_MMouseEvent_methods[] = {
    {NULL,                NULL,                   0} 
  };

  JSPropertySpec aztecMMouseEvent_props[] = {
    {"x", 0, JSPROP_ENUMERATE | JSPROP_READONLY, js_getX }, 
    {"y", 1, JSPROP_ENUMERATE | JSPROP_READONLY, js_getY },
    {"type", 1, JSPROP_ENUMERATE | JSPROP_READONLY, js_getType },
    {0, 0, 0, 0}
  };
  

  JSObject* initMMouseEventClass(JSContext *cx) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), NULL,
      &js_MMouseEvent_class, js_MMouseEvent_constructor, 0,
      NULL, js_MMouseEvent_methods, 0, 0);

    JSObject *con = JS_GetConstructor(cx, cl);

    if (con != NULL) {
      JS_DefineProperty(cx, con, "LBUTTON_DOWN", INT_TO_JSVAL(MMouseEvent::LBUTTON_DOWN), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "LBUTTON_UP", INT_TO_JSVAL(MMouseEvent::LBUTTON_UP), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "LBUTTON_DBLCLK", INT_TO_JSVAL(MMouseEvent::LBUTTON_DBLCLK), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "MBUTTON_DOWN", INT_TO_JSVAL(MMouseEvent::MBUTTON_DOWN), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "MBUTTON_UP", INT_TO_JSVAL(MMouseEvent::MBUTTON_UP), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "MBUTTON_DBLCLK", INT_TO_JSVAL(MMouseEvent::MBUTTON_DBLCLK), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "RBUTTON_DOWN", INT_TO_JSVAL(MMouseEvent::RBUTTON_DOWN), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "RBUTTON_UP", INT_TO_JSVAL(MMouseEvent::RBUTTON_UP), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "RBUTTON_DBLCLK", INT_TO_JSVAL(MMouseEvent::RBUTTON_DBLCLK), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
      JS_DefineProperty(cx, con, "MOVE", INT_TO_JSVAL(MMouseEvent::MOVE), NULL, NULL, JSPROP_READONLY | JSPROP_PERMANENT );
    }

    return cl;
  }

  JSObject* createMouseEvent(JSContext *cx, JSObject *parent, const MMouseEvent &event) {
    JSObject *object = JS_NewObject(cx, &js_MMouseEvent_class, NULL, parent);
    JS_DefineProperties(cx, object, aztecMMouseEvent_props);
    JS_SetPrivate(cx, object, new MMouseEvent(event)) ;
    return object;
  }

}
