#include <AztecGUICommonPCH.h>
#include <gui/MContainer.h>

#include <gui/win32/MAppImpl.h>
#include <gui/win32/MContainerImpl.h>

#include <algorithm>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

using Aztec::MContainerPtr;
using Aztec::MComponentPtr;
using Aztec::MConstraint;
using Aztec::MLayoutManagerPtr;
using Aztec::MPoint2D;

namespace Aztec {


  MContainer::MContainer() {
  }

  MContainer::MContainer(const std::string &name) {
  }

  MContainer::MContainer(MContainerPtr parent) {
  }

  MContainer::MContainer(const std::string &name, MContainerPtr *parent) {
  }

  MContainer::MContainer(int X, int Y, int width, int height) {
  }

  MContainer::~MContainer() {
  }

  bool MContainer::createImpl() {
    if (m_hWnd != NULL) {
      // if we have already had ourselves created, don't create us again.
      return true;
    }

    MApp *app;
    HWND parentHWND = NULL;

    if (m_Parent != NULL) {
      parentHWND = m_Parent->getHWnd();
    }

    app = MApp::getInstance();

    m_hWnd = ::CreateWindow((LPCTSTR)app->getWindowClass("container"), NULL, WS_CHILD | WS_CLIPCHILDREN,
                            0, 10, 0, 10, parentHWND, NULL, app->getHInstance(), NULL);

    if (m_hWnd != 0) {
      app->registerComponent(m_hWnd, this);

      onCreate();

      setVisible(true);
      ::UpdateWindow(m_hWnd);

      return true;
    } else {
      DWORD err = ::GetLastError();
      printf("error: %i", err);
    }

    return false;
  }


  int MContainer::getComponentCount() {
    return m_Children.size();
  }

  MComponentPtr MContainer::getComponent(int index) {
    if (index < 0 || index >= m_Children.size()) {
      return NULL;
    }

    return m_Children[index];
  }

  void MContainer::addComponent(MComponentPtr component) {
    addComponent(component, MConstraint());
  }

  void MContainer::addComponent(MComponentPtr component, int index) {
    addComponent(component, index, MConstraint());
  }

  void MContainer::addComponent(MComponentPtr component, MConstraint constraints) {
    if (getComponentIndex(component) != -1) {
      return;
    }

    m_Children.push_back(component);

    // add it to the layout manager if appropriate.
    if (m_LayoutManager != NULL) {
      if (constraints == MConstraint()) {
        m_LayoutManager->addComponent(component);
      } else {
        m_LayoutManager->addComponent(component, constraints);
      }
    }

    // set the parent.
    if (component->getParent() != this) {
      component->setParent(this);
    }

    doLayout();
  }

  void MContainer::addComponent(MComponentPtr component, int index, MConstraint constraints) {
    if (getComponentIndex(component) != -1) {
      return;
    }

    // clamp the index to be 0 or greater
    if (index < 0) {
      index = 0;
    }

    // clamp the index so it is the number of children or less.
    if (index > m_Children.size()) {
      index = m_Children.size();
    }

    // insert the child.
    m_Children.insert(m_Children.begin() + index, component);

    // add it to the layout manager if appropriate.
    if (m_LayoutManager != NULL) {
      if (constraints == MConstraint()) {
        m_LayoutManager->addComponent(component);
      } else {
        m_LayoutManager->addComponent(component, constraints);
      }
    }

    // set the parent.
    if (component->getParent() != this) {
      component->setParent(this);
    }

    doLayout();
  }


  void MContainer::removeComponent(int index) {
    if (index < 0 || index >= m_Children.size()) {
      return;
    }

    MComponentPtr comp = m_Children[index];

    // remove it from the layout manager first.
    if (m_LayoutManager != NULL) {
      m_LayoutManager->removeComponent(comp);
    }

    m_Children.erase(m_Children.begin() + index);

    comp->destroyImpl();
    comp->setParent(NULL);

    doLayout();

  }

  void MContainer::removeComponent(MComponentPtr component) {
    int index = getComponentIndex(component);;

    // if the component was be found, remove it.
    if (index != -1) {
      removeComponent(index);
    }

  }

  int MContainer::getComponentIndex(MComponentPtr component) {
    for (int index = 0; index < m_Children.size(); ++index) {
      if (m_Children[index] == component) {
        return index;
      }
    }

    return -1;
  }


  void MContainer::setLayoutManager(MLayoutManagerPtr layout) {
    m_LayoutManager = layout;

    if (m_LayoutManager != NULL) {
      // add all the current components to the layout manager
      for (int n = 0;n < m_Children.size(); ++n) {
        m_LayoutManager->addComponent(m_Children[n]);
      }
    }
  }

  MLayoutManagerPtr MContainer::getLayoutManager() {
    return m_LayoutManager;
  }

  void MContainer::doLayout() {
    if (m_LayoutManager != NULL) {
      m_LayoutManager->layoutContainer(this);
    }
    // loop over all the compontents, and force a layout of any child contanier.
    for (int i = 0; i < m_Children.size(); ++i) {
      MContainerPtr cont = AZTEC_CAST(MContainer, m_Children[i]);
      if (cont != NULL) {
        cont->doLayout();
      }
    }
  }

  MSize2D MContainer::getClientSize() {
    RECT rect;
    ::GetClientRect(m_hWnd, &rect);

    return MSize2D(rect.left, rect.top, rect.right, rect.bottom);
  }

  bool MContainer::onCommand(const std::string &command, const MComponentPtr &component) {
    return false;
  }

  MSize2D MContainer::getMinimumSize() {
    MSize2D min = MComponent::getMinimumSize();
    if (m_LayoutManager != NULL) {
      MSize2D layoutSize = m_LayoutManager->getMinimumSize(this);

      min.setWidth(min.getWidth() > layoutSize.getWidth() ? min.getWidth() : layoutSize.getWidth());
      min.setHeight(min.getHeight() > layoutSize.getHeight() ? min.getHeight() : layoutSize.getHeight());
    }

    return min;
  }

  MSize2D MContainer::getPreferredSize() {
    MSize2D pref = MComponent::getPreferredSize();
    if (m_LayoutManager != NULL) {
      MSize2D layoutSize = m_LayoutManager->getPreferredSize(this);
      pref.setWidth(pref.getWidth() > layoutSize.getWidth() ? pref.getWidth() : layoutSize.getWidth());
      pref.setHeight(pref.getHeight() > layoutSize.getHeight() ? pref.getHeight() : layoutSize.getHeight());
    }

    return pref;

  }

  void MContainer::setVisible(bool visible) {
    // if we are showing the container, make sure we do a layout before making it visible);
    if (visible) {
      doLayout();
    }

    MComponent::setVisible(visible);
  }

  void MContainer::refresh() {
    // invalidate all the child components
    for (int i = 0; i < m_Children.size(); ++i) {
      m_Children[i]->refresh();
    }

    MComponent::refresh();
  }

  bool MContainer::onResize(int newWidth, int newHeight) {
    MComponent::onResize(newWidth, newHeight);

    doLayout();

    return true;
  }

  bool MContainer::onShow() {
    MComponent::onShow();

    doLayout();

    return true;
  }

  bool MContainer::onPaint() {
    // paint in a big empty flat rectangle.
    if (paintDC != NULL) {
      HBRUSH b = NULL;
      
      if (bgColourSet) {
        DWORD rgb = RGB(bgColour.getRuchar(), bgColour.getGuchar(), bgColour.getBuchar());
        b = ::CreateSolidBrush(rgb);
      } else {
        b = ::GetSysColorBrush(COLOR_3DFACE);
      }
      RECT rect;

      ::GetClientRect(m_hWnd, &rect);

      ::FillRect(paintDC, &rect, b);

      ::DeleteObject(b);
    }

    return false;

  }

}

