#ifndef MBaseUndoNode_Header
#define MBaseUndoNode_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MBaseUndoNode;
  class MUndoableObject;
  
  typedef MRefCountedPtr<MBaseUndoNode> MBaseUndoNodePtr;
  typedef MRefCountedPtr<MUndoableObject> MUndoableObjectPtr;

}

#include "MStr.h"

namespace Aztec {

  /**
   * This is the base class for all undo nodes in the system.
   */
  class MGENEXPORT MBaseUndoNode : public MRefCountedObject {
  public: 
    /**
     * Gets the object that this undo node works on.
     */
    virtual MUndoableObject* getObject() = 0;

    /**
     * This execute the undo operation.
     */
    virtual void undo() = 0;
    /**
     * Tells the undo node to reverse its actions. This is
     * used when an undo node is moved from the undo stack to
     * redo stack and vice verca.
     */
    virtual void redo() = 0;

  };

  class MGENEXPORT MUndoableObject {
  public:
    virtual void finishWithUndoNode() = 0;
  };

}

#endif
